/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.LinkedHashSet;
import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ComponentModuleMetadataDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.notations.ModuleIdentiferNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentModuleMetadataContainer
implements ModuleReplacementsData {
    private final Map<ModuleIdentifier, ModuleIdentifier> replacements = Maps.newHashMap();

    public ComponentModuleMetadataDetails module(Object sourceModule) {
        final NotationParser<Object, ModuleIdentifier> parser = ComponentModuleMetadataContainer.parser();
        final ModuleIdentifier source = (ModuleIdentifier)parser.parseNotation(sourceModule);
        return new ComponentModuleMetadataDetails(){

            public void replacedBy(Object targetModule) {
                ModuleIdentifier target = (ModuleIdentifier)parser.parseNotation(targetModule);
                ComponentModuleMetadataContainer.detectCycles(ComponentModuleMetadataContainer.this.replacements, source, target);
                ComponentModuleMetadataContainer.this.replacements.put(source, target);
            }

            public ModuleIdentifier getId() {
                return source;
            }

            public ModuleIdentifier getReplacedBy() {
                return (ModuleIdentifier)ComponentModuleMetadataContainer.this.replacements.get(source);
            }
        };
    }

    @Override
    public ModuleIdentifier getReplacementFor(ModuleIdentifier sourceModule) {
        return this.replacements.get(sourceModule);
    }

    private static void detectCycles(Map<ModuleIdentifier, ModuleIdentifier> replacements, ModuleIdentifier source, ModuleIdentifier target) {
        if (source.equals(target)) {
            throw new InvalidUserDataException(String.format("Cannot declare module replacement that replaces self: %s->%s", source, target));
        }
        ModuleIdentifier m = replacements.get(target);
        if (m == null) {
            return;
        }
        LinkedHashSet<ModuleIdentifier> visited = new LinkedHashSet<ModuleIdentifier>();
        visited.add(source);
        visited.add(target);
        while (m != null) {
            if (!visited.add(m)) {
                throw new InvalidUserDataException(String.format("Cannot declare module replacement %s->%s because it introduces a cycle: %s", source, target, Joiner.on((String)"->").join(visited) + "->" + source));
            }
            m = replacements.get(m);
        }
    }

    private static NotationParser<Object, ModuleIdentifier> parser() {
        return NotationParserBuilder.toType(ModuleIdentifier.class).converter((NotationConverter)new ModuleIdentiferNotationConverter()).toComposite();
    }
}

