/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencyResolveDetailsInternal;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dsl.ModuleVersionSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyResolveDetails
implements DependencyResolveDetailsInternal {
    private final DependencySubstitutionInternal<?> delegate;
    private ModuleVersionSelector target;

    public DefaultDependencyResolveDetails(DependencySubstitutionInternal<?> delegate) {
        this.delegate = delegate;
        this.target = DefaultDependencyResolveDetails.determineTarget(delegate);
    }

    private static ModuleVersionSelector determineTarget(DependencySubstitutionInternal<?> delegate) {
        if (delegate.getTarget() instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)delegate.getTarget();
            return DefaultModuleVersionSelector.newSelector(moduleComponentSelector.getGroup(), moduleComponentSelector.getModule(), moduleComponentSelector.getVersion());
        }
        return delegate.getOldRequested();
    }

    public ModuleVersionSelector getRequested() {
        return this.delegate.getOldRequested();
    }

    public void useVersion(String version) {
        this.useVersion(version, VersionSelectionReasons.SELECTED_BY_RULE);
    }

    public void useVersion(String version, ComponentSelectionReason selectionReason) {
        assert (selectionReason != null);
        if (version == null) {
            throw new IllegalArgumentException("Configuring the dependency resolve details with 'null' version is not allowed.");
        }
        if (!version.equals(this.target.getVersion())) {
            this.target = DefaultModuleVersionSelector.newSelector(this.target.getGroup(), this.target.getName(), version);
            this.delegate.useTarget((Object)DefaultModuleComponentSelector.newSelector(this.target), selectionReason);
        } else {
            this.delegate.useTarget((Object)this.delegate.getTarget(), selectionReason);
        }
    }

    public void useTarget(Object notation) {
        this.target = (ModuleVersionSelector)ModuleVersionSelectorParsers.parser().parseNotation(notation);
        this.delegate.useTarget((Object)DefaultModuleComponentSelector.newSelector(this.target), VersionSelectionReasons.SELECTED_BY_RULE);
    }

    public ComponentSelectionReason getSelectionReason() {
        return this.delegate.getSelectionReason();
    }

    public ModuleVersionSelector getTarget() {
        return this.target;
    }

    public boolean isUpdated() {
        return this.delegate.isUpdated();
    }
}

