/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.AbstractDependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.DefaultModuleDependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.DefaultProjectDependencySubstitution;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencySubstitutionResolver
implements DependencyToComponentIdResolver {
    private final DependencyToComponentIdResolver resolver;
    private final Action<DependencySubstitution<ComponentSelector>> rule;

    public DependencySubstitutionResolver(DependencyToComponentIdResolver resolver, Action<DependencySubstitution<ComponentSelector>> rule) {
        this.resolver = resolver;
        this.rule = rule;
    }

    @Override
    public void resolve(DependencyMetaData dependency, BuildableComponentIdResolveResult result) {
        AbstractDependencySubstitution details;
        ComponentSelector selector = dependency.getSelector();
        if (selector instanceof ModuleComponentSelector) {
            details = new DefaultModuleDependencySubstitution((ModuleComponentSelector)selector, dependency.getRequested());
        } else if (selector instanceof ProjectComponentSelector) {
            details = new DefaultProjectDependencySubstitution((ProjectComponentSelector)selector, dependency.getRequested());
        } else {
            throw new IllegalStateException("Unknown type of component selector: " + selector);
        }
        try {
            this.rule.execute((Object)details);
        }
        catch (Throwable e) {
            result.failed(new ModuleVersionResolveException(selector, e));
            return;
        }
        if (details.isUpdated()) {
            this.resolver.resolve(dependency.withTarget(details.getTarget()), result);
            result.setSelectionReason(details.getSelectionReason());
            return;
        }
        this.resolver.resolve(dependency, result);
    }
}

