/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.Collections;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.util.GUtil;

public class IvyUtil {
    private static final Object MODULE_ID_LOCK = new Object();

    public static ModuleRevisionId createModuleRevisionId(Module module) {
        return IvyUtil.createModuleRevisionId(module.getGroup(), module.getName(), module.getVersion());
    }

    public static ModuleRevisionId createModuleRevisionId(Dependency dependency) {
        return IvyUtil.createModuleRevisionId(dependency.getGroup(), dependency.getName(), dependency.getVersion());
    }

    public static ModuleRevisionId createModuleRevisionId(String group, String name, String version) {
        return IvyUtil.createModuleRevisionId(IvyUtil.emptyStringIfNull(group), name, null, IvyUtil.emptyStringIfNull(version), Collections.emptyMap());
    }

    public static ModuleRevisionId createModuleRevisionId(ModuleVersionIdentifier id) {
        return IvyUtil.createModuleRevisionId(id.getGroup(), id.getName(), id.getVersion());
    }

    public static ModuleRevisionId createModuleRevisionId(ModuleComponentIdentifier id) {
        return IvyUtil.createModuleRevisionId(id.getGroup(), id.getModule(), id.getVersion());
    }

    public static ModuleRevisionId createModuleRevisionId(ModuleRevisionId revId, String version) {
        return IvyUtil.createModuleRevisionId(revId.getOrganisation(), revId.getName(), revId.getBranch(), version, revId.getQualifiedExtraAttributes());
    }

    private static String emptyStringIfNull(String value) {
        return (String)GUtil.elvis((Object)value, (Object)"");
    }

    public static ModuleRevisionId createModuleRevisionId(String org, String name, String branch, String rev, Map extraAttributes) {
        return IvyUtil.createModuleRevisionId(org, name, branch, rev, extraAttributes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleRevisionId createModuleRevisionId(String org, String name, String branch, String revConstraint, Map extraAttributes, boolean replaceNullBranchWithDefault) {
        Object object = MODULE_ID_LOCK;
        synchronized (object) {
            return ModuleRevisionId.newInstance((String)org, (String)name, (String)branch, (String)revConstraint, (Map)extraAttributes, (boolean)replaceNullBranchWithDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleId createModuleId(String org, String name) {
        Object object = MODULE_ID_LOCK;
        synchronized (object) {
            return ModuleId.newInstance((String)org, (String)name);
        }
    }

    public static ArtifactId createArtifactId(String org, String module, String name, String type, String ext) {
        return new ArtifactId(IvyUtil.createModuleId(org, module), name, type, ext);
    }

    public static DefaultModuleDescriptor createModuleDescriptor(DependencyDescriptor dependencyDescriptor) {
        DefaultModuleDescriptor moduleDescriptor = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)dependencyDescriptor.getDependencyRevisionId(), (DependencyArtifactDescriptor[])dependencyDescriptor.getAllDependencyArtifacts());
        moduleDescriptor.setStatus("integration");
        return moduleDescriptor;
    }
}

