/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.base.Joiner;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.artifacts.ivyservice.IvyModuleDescriptorWriter;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.xml.SimpleXmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyXmlModuleDescriptorWriter
implements IvyModuleDescriptorWriter {
    public static final String IVY_DATE_PATTERN = "yyyyMMddHHmmss";
    private final Field dependencyConfigField;

    public IvyXmlModuleDescriptorWriter() {
        try {
            this.dependencyConfigField = DefaultDependencyDescriptor.class.getDeclaredField("confs");
        }
        catch (NoSuchFieldException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.dependencyConfigField.setAccessible(true);
    }

    private void writeTo(ModuleDescriptor md, SimpleXmlWriter writer) throws IOException {
        writer.startElement("ivy-module");
        writer.attribute("version", "2.0");
        Map namespaces = md.getExtraAttributesNamespaces();
        for (Map.Entry entry : namespaces.entrySet()) {
            writer.attribute("xmlns:" + (String)entry.getKey(), (String)entry.getValue());
        }
        IvyXmlModuleDescriptorWriter.printInfoTag(md, writer);
        IvyXmlModuleDescriptorWriter.printConfigurations(md, writer);
        IvyXmlModuleDescriptorWriter.printPublications(md, writer);
        this.printDependencies(md, writer);
        writer.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ModuleDescriptor md, File output) {
        try {
            output.getParentFile().mkdirs();
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(output));
            try {
                SimpleXmlWriter xmlWriter = new SimpleXmlWriter((OutputStream)outputStream, "  ");
                this.writeTo(md, xmlWriter);
                xmlWriter.flush();
            }
            finally {
                ((OutputStream)outputStream).close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void printDependencies(ModuleDescriptor md, SimpleXmlWriter writer) throws IOException {
        DependencyDescriptor[] dds = md.getDependencies();
        if (dds.length > 0) {
            writer.startElement("dependencies");
            for (int i = 0; i < dds.length; ++i) {
                DependencyDescriptor dep = dds[i];
                this.printDependency(md, dep, writer);
            }
            IvyXmlModuleDescriptorWriter.printAllExcludes(md, writer);
            writer.endElement();
        }
    }

    protected void printDependency(ModuleDescriptor md, DependencyDescriptor dep, SimpleXmlWriter writer) throws IOException {
        writer.startElement("dependency");
        ModuleRevisionId dependencyRevisionId = dep.getDependencyRevisionId();
        writer.attribute("org", dependencyRevisionId.getOrganisation());
        writer.attribute("name", dependencyRevisionId.getName());
        if (dependencyRevisionId.getBranch() != null) {
            writer.attribute("branch", dependencyRevisionId.getBranch());
        }
        writer.attribute("rev", dependencyRevisionId.getRevision());
        if (!dep.getDynamicConstraintDependencyRevisionId().equals((Object)dependencyRevisionId)) {
            if (dep.getDynamicConstraintDependencyRevisionId().getBranch() != null) {
                writer.attribute("branchConstraint", dep.getDynamicConstraintDependencyRevisionId().getBranch());
            }
            writer.attribute("revConstraint", dep.getDynamicConstraintDependencyRevisionId().getRevision());
        }
        if (dep.isForce()) {
            writer.attribute("force", "true");
        }
        if (dep.isChanging()) {
            writer.attribute("changing", "true");
        }
        if (!dep.isTransitive()) {
            writer.attribute("transitive", "false");
        }
        writer.attribute("conf", this.getConfMapping(dep));
        IvyXmlModuleDescriptorWriter.printExtraAttributes((ExtendableItem)dep, writer);
        DependencyArtifactDescriptor[] depArtifacts = dep.getAllDependencyArtifacts();
        IvyXmlModuleDescriptorWriter.printDependencyArtefacts(md, writer, depArtifacts);
        IncludeRule[] includes = dep.getAllIncludeRules();
        IvyXmlModuleDescriptorWriter.printDependencyIncludeRules(md, writer, includes);
        ExcludeRule[] excludes = dep.getAllExcludeRules();
        IvyXmlModuleDescriptorWriter.printDependencyExcludeRules(md, writer, excludes);
        writer.endElement();
    }

    private String getConfMapping(DependencyDescriptor dep) {
        Map<String, List<String>> configMappings;
        StringBuilder confs = new StringBuilder();
        String[] modConfs = dep.getModuleConfigurations();
        if (dep instanceof DefaultDependencyDescriptor) {
            try {
                configMappings = (Map)this.dependencyConfigField.get(dep);
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        } else {
            configMappings = new HashMap();
            for (String modConf : modConfs) {
                configMappings.put(modConf, Arrays.asList(dep.getDependencyConfigurations(modConfs)));
            }
        }
        for (int j = 0; j < modConfs.length; ++j) {
            List depConfs = (List)configMappings.get(modConfs[j]);
            confs.append(modConfs[j]).append("->");
            for (int k = 0; k < depConfs.size(); ++k) {
                confs.append((String)depConfs.get(k));
                if (k + 1 >= depConfs.size()) continue;
                confs.append(",");
            }
            if (j + 1 >= modConfs.length) continue;
            confs.append(";");
        }
        return confs.toString();
    }

    private static void printAllExcludes(ModuleDescriptor md, SimpleXmlWriter writer) throws IOException {
        ExcludeRule[] excludes;
        for (ExcludeRule exclude : excludes = md.getAllExcludeRules()) {
            writer.startElement("exclude");
            writer.attribute("org", exclude.getId().getModuleId().getOrganisation());
            writer.attribute("module", exclude.getId().getModuleId().getName());
            writer.attribute("artifact", exclude.getId().getName());
            writer.attribute("type", exclude.getId().getType());
            writer.attribute("ext", exclude.getId().getExt());
            Object[] ruleConfs = exclude.getConfigurations();
            if (!Arrays.asList(ruleConfs).equals(Arrays.asList(md.getConfigurationsNames()))) {
                writer.attribute("conf", Joiner.on((char)',').join(ruleConfs));
            }
            writer.attribute("matcher", exclude.getMatcher().getName());
            writer.endElement();
        }
    }

    private static void printDependencyExcludeRules(ModuleDescriptor md, SimpleXmlWriter writer, ExcludeRule[] excludes) throws IOException {
        for (ExcludeRule exclude : excludes) {
            writer.startElement("exclude");
            writer.attribute("org", exclude.getId().getModuleId().getOrganisation());
            writer.attribute("module", exclude.getId().getModuleId().getName());
            writer.attribute("name", exclude.getId().getName());
            writer.attribute("type", exclude.getId().getType());
            writer.attribute("ext", exclude.getId().getExt());
            Object[] ruleConfs = exclude.getConfigurations();
            if (!Arrays.asList(ruleConfs).equals(Arrays.asList(md.getConfigurationsNames()))) {
                writer.attribute("conf", Joiner.on((char)',').join(ruleConfs));
            }
            writer.attribute("matcher", exclude.getMatcher().getName());
            writer.endElement();
        }
    }

    private static void printDependencyIncludeRules(ModuleDescriptor md, SimpleXmlWriter writer, IncludeRule[] includes) throws IOException {
        for (IncludeRule include : includes) {
            writer.startElement("include");
            writer.attribute("name", include.getId().getName());
            writer.attribute("type", include.getId().getType());
            writer.attribute("ext", include.getId().getExt());
            Object[] ruleConfs = include.getConfigurations();
            if (!Arrays.asList(ruleConfs).equals(Arrays.asList(md.getConfigurationsNames()))) {
                writer.attribute("conf", Joiner.on((char)',').join(ruleConfs));
            }
            writer.attribute("matcher", include.getMatcher().getName());
            writer.endElement();
        }
    }

    private static void printDependencyArtefacts(ModuleDescriptor md, SimpleXmlWriter writer, DependencyArtifactDescriptor[] depArtifacts) throws IOException {
        for (DependencyArtifactDescriptor depArtifact : depArtifacts) {
            writer.startElement("artifact");
            writer.attribute("name", depArtifact.getName());
            writer.attribute("type", depArtifact.getType());
            writer.attribute("ext", depArtifact.getExt());
            Object[] dadconfs = depArtifact.getConfigurations();
            if (!Arrays.asList(dadconfs).equals(Arrays.asList(md.getConfigurationsNames()))) {
                writer.attribute("conf", Joiner.on((char)',').join(dadconfs));
            }
            IvyXmlModuleDescriptorWriter.printExtraAttributes((ExtendableItem)depArtifact, writer);
            writer.endElement();
        }
    }

    private static void printExtraAttributes(ExtendableItem item, SimpleXmlWriter writer) throws IOException {
        IvyXmlModuleDescriptorWriter.printExtraAttributes(item.getQualifiedExtraAttributes(), writer);
    }

    private static void printExtraAttributes(Map<String, ?> extra, SimpleXmlWriter writer) throws IOException {
        if (extra == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : extra.entrySet()) {
            writer.attribute(entry.getKey(), entry.getValue().toString());
        }
    }

    private static void printPublications(ModuleDescriptor md, SimpleXmlWriter writer) throws IOException {
        writer.startElement("publications");
        Artifact[] artifacts = md.getAllArtifacts();
        for (int i = 0; i < artifacts.length; ++i) {
            Artifact artifact = artifacts[i];
            writer.startElement("artifact");
            writer.attribute("name", artifact.getName());
            writer.attribute("type", artifact.getType());
            writer.attribute("ext", artifact.getExt());
            writer.attribute("conf", IvyXmlModuleDescriptorWriter.getConfs(artifact));
            IvyXmlModuleDescriptorWriter.printExtraAttributes((ExtendableItem)artifact, writer);
            writer.endElement();
        }
        writer.endElement();
    }

    private static void printConfigurations(ModuleDescriptor md, SimpleXmlWriter writer) throws IOException {
        Configuration[] confs = md.getConfigurations();
        if (confs.length > 0) {
            writer.startElement("configurations");
            for (Configuration conf : confs) {
                IvyXmlModuleDescriptorWriter.printConfiguration(conf, writer);
            }
            writer.endElement();
        }
    }

    private static void printConfiguration(Configuration conf, SimpleXmlWriter writer) throws IOException {
        Object[] exts;
        writer.startElement("conf");
        writer.attribute("name", conf.getName());
        writer.attribute("visibility", conf.getVisibility().toString());
        String description = conf.getDescription();
        if (description != null) {
            writer.attribute("description", description);
        }
        if ((exts = conf.getExtends()).length > 0) {
            writer.attribute("extends", Joiner.on((char)',').join(exts));
        }
        if (!conf.isTransitive()) {
            writer.attribute("transitive", "false");
        }
        if (conf.getDeprecated() != null) {
            writer.attribute("deprecated", conf.getDeprecated());
        }
        IvyXmlModuleDescriptorWriter.printExtraAttributes((ExtendableItem)conf, writer);
        writer.endElement();
    }

    private static void printInfoTag(ModuleDescriptor md, SimpleXmlWriter writer) throws IOException {
        ExtendsDescriptor[] parents;
        DefaultModuleDescriptor dmd;
        String revision;
        ModuleRevisionId moduleRevisionId = md.getModuleRevisionId();
        writer.startElement("info");
        writer.attribute("organisation", moduleRevisionId.getOrganisation());
        writer.attribute("module", moduleRevisionId.getName());
        ModuleRevisionId resolvedModuleRevisionId = md.getResolvedModuleRevisionId();
        String branch = resolvedModuleRevisionId.getBranch();
        if (branch != null) {
            writer.attribute("branch", branch);
        }
        if ((revision = resolvedModuleRevisionId.getRevision()) != null) {
            writer.attribute("revision", revision);
        }
        writer.attribute("status", md.getStatus());
        SimpleDateFormat ivyDateFormat = new SimpleDateFormat(IVY_DATE_PATTERN);
        Date publicationDate = md.getResolvedPublicationDate();
        if (publicationDate != null) {
            writer.attribute("publication", ivyDateFormat.format(publicationDate));
        }
        if (md.isDefault()) {
            writer.attribute("default", "true");
        }
        if (md instanceof DefaultModuleDescriptor && (dmd = (DefaultModuleDescriptor)md).getNamespace() != null && !dmd.getNamespace().getName().equals("system")) {
            writer.attribute("namespace", dmd.getNamespace().getName());
        }
        if (!md.getExtraAttributes().isEmpty()) {
            IvyXmlModuleDescriptorWriter.printExtraAttributes((ExtendableItem)md, writer);
        }
        if ((parents = md.getInheritedDescriptors()).length != 0) {
            throw new UnsupportedOperationException("Extends descriptors not supported.");
        }
        License[] licenses = md.getLicenses();
        for (int i = 0; i < licenses.length; ++i) {
            License license = licenses[i];
            writer.startElement("license");
            if (license.getName() != null) {
                writer.attribute("name", license.getName());
            }
            if (license.getUrl() != null) {
                writer.attribute("url", license.getUrl());
            }
            writer.endElement();
        }
        if (md.getHomePage() != null || md.getDescription() != null) {
            writer.startElement("description");
            if (md.getHomePage() != null) {
                writer.attribute("homepage", md.getHomePage());
            }
            if (md.getDescription() != null && md.getDescription().trim().length() > 0) {
                writer.characters((CharSequence)md.getDescription());
            }
            writer.endElement();
        }
        for (Map.Entry extraDescr : md.getExtraInfo().entrySet()) {
            if (extraDescr.getValue() == null || ((String)extraDescr.getValue()).length() == 0) continue;
            if (extraDescr.getKey() instanceof NamespaceId) {
                NamespaceId id = (NamespaceId)extraDescr.getKey();
                writer.startElement(String.format("ns:%s", id.getName()));
                writer.attribute("xmlns:ns", id.getNamespace());
            } else {
                writer.startElement(extraDescr.getKey().toString());
            }
            writer.characters((CharSequence)extraDescr.getValue().toString());
            writer.endElement();
        }
        writer.endElement();
    }

    private static String getConfs(Artifact artifact) {
        return Joiner.on((String)",").join((Object[])artifact.getConfigurations());
    }
}

