/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentUsage;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

public class LocalModuleComponentRepository
extends BaseModuleComponentRepository {
    private final ComponentMetadataProcessor metadataProcessor;
    private final LocalAccess localAccess = new LocalAccess();
    private final RemoteAccess remoteAccess = new RemoteAccess();

    public LocalModuleComponentRepository(ModuleComponentRepository delegate, ComponentMetadataProcessor metadataProcessor) {
        super(delegate);
        this.metadataProcessor = metadataProcessor;
    }

    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.localAccess;
    }

    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remoteAccess;
    }

    private static class RemoteAccess
    implements ModuleComponentRepositoryAccess {
        private RemoteAccess() {
        }

        public String toString() {
            return "empty";
        }

        public void listModuleVersions(DependencyMetaData dependency, BuildableModuleVersionListingResolveResult result) {
        }

        public void resolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleComponentMetaDataResolveResult result) {
        }

        public void resolveModuleArtifacts(ComponentResolveMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        }

        public void resolveModuleArtifacts(ComponentResolveMetaData component, ComponentUsage componentUsage, BuildableArtifactSetResolveResult result) {
        }

        public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        }
    }

    private class LocalAccess
    implements ModuleComponentRepositoryAccess {
        private LocalAccess() {
        }

        public String toString() {
            return "local adapter > " + LocalModuleComponentRepository.this.delegate.toString();
        }

        public void listModuleVersions(DependencyMetaData dependency, BuildableModuleVersionListingResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().listModuleVersions(dependency, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().listModuleVersions(dependency, result);
            }
        }

        public void resolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleComponentMetaDataResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().resolveComponentMetaData(dependency, moduleComponentIdentifier, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().resolveComponentMetaData(dependency, moduleComponentIdentifier, result);
            }
            if (result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
                LocalModuleComponentRepository.this.metadataProcessor.processMetadata(result.getMetaData());
            }
        }

        public void resolveModuleArtifacts(ComponentResolveMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().resolveModuleArtifacts(component, artifactType, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().resolveModuleArtifacts(component, artifactType, result);
            }
        }

        public void resolveModuleArtifacts(ComponentResolveMetaData component, ComponentUsage componentUsage, BuildableArtifactSetResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().resolveModuleArtifacts(component, componentUsage, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().resolveModuleArtifacts(component, componentUsage, result);
            }
        }

        public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().resolveArtifact(artifact, moduleSource, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().resolveArtifact(artifact, moduleSource, result);
            }
        }
    }
}

