/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.XMLHelper;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomDomParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomParent;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.RootPomParent;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.MavenDependencyKey;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomDependencyMgt;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomProfile;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomReader
implements PomParent {
    private static final String PACKAGING = "packaging";
    private static final String DEPENDENCY = "dependency";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCY_MGT = "dependencyManagement";
    private static final String PROJECT = "project";
    private static final String MODEL = "model";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String DESCRIPTION = "description";
    private static final String HOMEPAGE = "url";
    private static final String LICENSES = "licenses";
    private static final String LICENSE = "license";
    private static final String LICENSE_NAME = "name";
    private static final String LICENSE_URL = "url";
    private static final String PARENT = "parent";
    private static final String SCOPE = "scope";
    private static final String CLASSIFIER = "classifier";
    private static final String OPTIONAL = "optional";
    private static final String EXCLUSIONS = "exclusions";
    private static final String EXCLUSION = "exclusion";
    private static final String DISTRIBUTION_MGT = "distributionManagement";
    private static final String RELOCATION = "relocation";
    private static final String PROPERTIES = "properties";
    private static final String TYPE = "type";
    private static final String PROFILES = "profiles";
    private static final String PROFILE = "profile";
    private static final String PROFILE_ID = "id";
    private static final String PROFILE_ACTIVATION = "activation";
    private static final String PROFILE_ACTIVATION_ACTIVE_BY_DEFAULT = "activeByDefault";
    private static final String PROFILE_ACTIVATION_PROPERTY = "property";
    private PomParent pomParent = new RootPomParent();
    private final Map<String, String> properties = new HashMap<String, String>();
    private List<PomDependencyMgt> declaredDependencyMgts;
    private List<PomProfile> declaredActivePomProfiles;
    private Map<MavenDependencyKey, PomDependencyMgt> resolvedDependencyMgts;
    private final Map<MavenDependencyKey, PomDependencyMgt> importedDependencyMgts = new LinkedHashMap<MavenDependencyKey, PomDependencyMgt>();
    private Map<MavenDependencyKey, PomDependencyData> resolvedDependencies;
    private final Element projectElement;
    private final Element parentElement;

    public PomReader(final LocallyAvailableExternalResource resource) throws SAXException {
        final String systemId = resource.getLocalResource().getFile().toURI().toASCIIString();
        Document pomDomDoc = (Document)resource.withContent((Transformer)new Transformer<Document, InputStream>(){

            public Document transform(InputStream inputStream) {
                try {
                    return PomReader.parseToDom(inputStream, systemId);
                }
                catch (Exception e) {
                    throw new MetaDataParseException("POM", (ExternalResource)resource, e);
                }
            }
        });
        this.projectElement = pomDomDoc.getDocumentElement();
        if (!PROJECT.equals(this.projectElement.getNodeName()) && !MODEL.equals(this.projectElement.getNodeName())) {
            throw new SAXParseException("project must be the root tag", systemId, systemId, 0, 0);
        }
        this.parentElement = PomDomParser.getFirstChildElement(this.projectElement, PARENT);
        this.setDefaultParentGavProperties();
        this.setPomProperties();
        this.setActiveProfileProperties();
    }

    public void setPomParent(PomParent pomParent) {
        this.pomParent = pomParent;
        this.setPomParentProperties();
    }

    private void setPomParentProperties() {
        Map<String, String> parentPomProps = this.pomParent.getProperties();
        for (Map.Entry<String, String> entry : parentPomProps.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private void setPomProperties() {
        for (Map.Entry<String, String> pomProperty : this.getPomProperties().entrySet()) {
            this.setProperty(pomProperty.getKey(), pomProperty.getValue());
        }
    }

    private void setActiveProfileProperties() {
        for (PomProfile activePomProfile : this.parseActivePomProfiles()) {
            for (Map.Entry<String, String> property : activePomProfile.getProperties().entrySet()) {
                this.properties.put(property.getKey(), property.getValue());
            }
        }
    }

    private void setDefaultParentGavProperties() {
        this.setGavPropertyValueWithoutReplacement(GavProperty.PARENT_GROUP_ID, this.getParentGroupId());
        this.setGavPropertyValueWithoutReplacement(GavProperty.PARENT_VERSION, this.getParentVersion());
    }

    private void setGavPropertyValueWithoutReplacement(GavProperty gavProperty, String propertyValue) {
        for (String name : gavProperty.getNames()) {
            this.setProperty(name, propertyValue);
        }
    }

    public String toString() {
        return this.projectElement.getOwnerDocument().getDocumentURI();
    }

    public static Document parseToDom(InputStream stream, String systemId) throws IOException, SAXException {
        EntityResolver entityResolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId != null && systemId.endsWith("m2-entities.ent")) {
                    return new InputSource(org.apache.ivy.plugins.parser.m2.PomReader.class.getResourceAsStream("m2-entities.ent"));
                }
                return null;
            }
        };
        PomDomParser.AddDTDFilterInputStream dtdStream = new PomDomParser.AddDTDFilterInputStream(stream);
        DocumentBuilder docBuilder = XMLHelper.getDocBuilder((EntityResolver)entityResolver);
        return docBuilder.parse(dtdStream, systemId);
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    public void setProperty(String prop, String val) {
        if (!this.properties.containsKey(prop) && val != null) {
            this.properties.put(prop, val);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addImportedDependencyMgts(Map<MavenDependencyKey, PomDependencyMgt> inherited) {
        if (this.resolvedDependencyMgts != null) {
            throw new IllegalStateException("Cannot add imported dependency management elements after dependency management elements have been resolved for this POM.");
        }
        this.importedDependencyMgts.putAll(inherited);
    }

    public String getGroupId() {
        String groupId = PomDomParser.getFirstChildText(this.projectElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomDomParser.getFirstChildText(this.parentElement, GROUP_ID);
        }
        return this.replaceProps(groupId);
    }

    public String getParentGroupId() {
        String groupId = PomDomParser.getFirstChildText(this.parentElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomDomParser.getFirstChildText(this.projectElement, GROUP_ID);
        }
        return this.replaceProps(groupId);
    }

    public String getArtifactId() {
        String val = PomDomParser.getFirstChildText(this.projectElement, ARTIFACT_ID);
        if (val == null) {
            val = PomDomParser.getFirstChildText(this.parentElement, ARTIFACT_ID);
        }
        return this.replaceProps(val);
    }

    public String getParentArtifactId() {
        String val = PomDomParser.getFirstChildText(this.parentElement, ARTIFACT_ID);
        if (val == null) {
            val = PomDomParser.getFirstChildText(this.projectElement, ARTIFACT_ID);
        }
        return this.replaceProps(val);
    }

    public String getVersion() {
        String val = PomDomParser.getFirstChildText(this.projectElement, VERSION);
        if (val == null) {
            val = PomDomParser.getFirstChildText(this.parentElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getParentVersion() {
        String val = PomDomParser.getFirstChildText(this.parentElement, VERSION);
        if (val == null) {
            val = PomDomParser.getFirstChildText(this.projectElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getPackaging() {
        String val = PomDomParser.getFirstChildText(this.projectElement, PACKAGING);
        if (val == null) {
            val = "jar";
        }
        return this.replaceProps(val);
    }

    public String getHomePage() {
        String val = PomDomParser.getFirstChildText(this.projectElement, "url");
        if (val == null) {
            val = "";
        }
        return val;
    }

    public String getDescription() {
        String val = PomDomParser.getFirstChildText(this.projectElement, DESCRIPTION);
        if (val == null) {
            val = "";
        }
        return val.trim();
    }

    public List<License> getLicenses() {
        Element licenses = PomDomParser.getFirstChildElement(this.projectElement, LICENSES);
        if (licenses == null) {
            return Collections.emptyList();
        }
        licenses.normalize();
        ArrayList<License> lics = new ArrayList<License>();
        for (Element license : PomDomParser.getAllChilds(licenses)) {
            if (!LICENSE.equals(license.getNodeName())) continue;
            String name = PomDomParser.getFirstChildText(license, LICENSE_NAME);
            String url = PomDomParser.getFirstChildText(license, "url");
            if (name == null && url == null) continue;
            if (name == null) {
                name = "Unknown License";
            }
            lics.add(new License(name, url));
        }
        return lics;
    }

    public ModuleRevisionId getRelocation() {
        Element distrMgt = PomDomParser.getFirstChildElement(this.projectElement, DISTRIBUTION_MGT);
        Element relocation = PomDomParser.getFirstChildElement(distrMgt, RELOCATION);
        if (relocation == null) {
            return null;
        }
        String relocGroupId = PomDomParser.getFirstChildText(relocation, GROUP_ID);
        String relocArtId = PomDomParser.getFirstChildText(relocation, ARTIFACT_ID);
        String relocVersion = PomDomParser.getFirstChildText(relocation, VERSION);
        relocGroupId = relocGroupId == null ? this.getGroupId() : relocGroupId;
        relocArtId = relocArtId == null ? this.getArtifactId() : relocArtId;
        relocVersion = relocVersion == null ? this.getVersion() : relocVersion;
        return IvyUtil.createModuleRevisionId(relocGroupId, relocArtId, relocVersion);
    }

    @Override
    public Map<MavenDependencyKey, PomDependencyData> getDependencies() {
        if (this.resolvedDependencies == null) {
            this.resolvedDependencies = this.resolveDependencies();
        }
        return this.resolvedDependencies;
    }

    private Map<MavenDependencyKey, PomDependencyData> resolveDependencies() {
        LinkedHashMap<MavenDependencyKey, PomDependencyData> dependencies = new LinkedHashMap<MavenDependencyKey, PomDependencyData>();
        for (PomDependencyData pomDependencyData : this.getDependencyData(this.projectElement)) {
            dependencies.put(pomDependencyData.getId(), pomDependencyData);
        }
        for (Map.Entry entry : this.pomParent.getDependencies().entrySet()) {
            if (dependencies.containsKey(entry.getKey())) continue;
            dependencies.put((MavenDependencyKey)entry.getKey(), (PomDependencyData)entry.getValue());
        }
        for (PomProfile pomProfile : this.parseActivePomProfiles()) {
            for (PomDependencyData dependency : pomProfile.getDependencies()) {
                dependencies.put(dependency.getId(), dependency);
            }
        }
        return dependencies;
    }

    private List<PomDependencyData> getDependencyData(Element parentElement) {
        ArrayList<PomDependencyData> depElements = new ArrayList<PomDependencyData>();
        Element dependenciesElement = PomDomParser.getFirstChildElement(parentElement, DEPENDENCIES);
        if (dependenciesElement != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                depElements.add(new PomDependencyData((Element)node));
            }
        }
        return depElements;
    }

    @Override
    public Map<MavenDependencyKey, PomDependencyMgt> getDependencyMgt() {
        if (this.resolvedDependencyMgts == null) {
            this.resolvedDependencyMgts = this.resolveDependencyMgt();
        }
        return this.resolvedDependencyMgts;
    }

    private Map<MavenDependencyKey, PomDependencyMgt> resolveDependencyMgt() {
        LinkedHashMap<MavenDependencyKey, PomDependencyMgt> dependencies = new LinkedHashMap<MavenDependencyKey, PomDependencyMgt>();
        dependencies.putAll(this.pomParent.getDependencyMgt());
        dependencies.putAll(this.importedDependencyMgts);
        for (PomDependencyMgt dependencyMgt : this.parseDependencyMgt()) {
            dependencies.put(dependencyMgt.getId(), dependencyMgt);
        }
        return dependencies;
    }

    public List<PomDependencyMgt> parseDependencyMgt() {
        if (this.declaredDependencyMgts == null) {
            List<PomDependencyMgt> dependencyMgts = this.getDependencyMgt(this.projectElement);
            for (PomProfile pomProfile : this.parseActivePomProfiles()) {
                for (PomDependencyMgt dependencyMgt : pomProfile.getDependencyMgts()) {
                    dependencyMgts.add(dependencyMgt);
                }
            }
            this.declaredDependencyMgts = dependencyMgts;
        }
        return this.declaredDependencyMgts;
    }

    private List<PomDependencyMgt> getDependencyMgt(Element parentElement) {
        ArrayList<PomDependencyMgt> depMgmtElements = new ArrayList<PomDependencyMgt>();
        Element dependenciesElement = PomDomParser.getFirstChildElement(parentElement, DEPENDENCY_MGT);
        if ((dependenciesElement = PomDomParser.getFirstChildElement(dependenciesElement, DEPENDENCIES)) != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                depMgmtElements.add(new PomDependencyMgtElement((Element)node));
            }
        }
        return depMgmtElements;
    }

    @Override
    public PomDependencyMgt findDependencyDefaults(MavenDependencyKey dependencyKey) {
        return this.getDependencyMgt().get(dependencyKey);
    }

    public void resolveGAV() {
        this.setGavPropertyValue(GavProperty.GROUP_ID, this.getGroupId());
        this.setGavPropertyValue(GavProperty.ARTIFACT_ID, this.getArtifactId());
        this.setGavPropertyValue(GavProperty.VERSION, this.getVersion());
    }

    private void setGavPropertyValue(GavProperty gavProperty, String propertyValue) {
        for (String name : gavProperty.getNames()) {
            this.properties.put(name, propertyValue);
        }
    }

    private List<PomProfile> parseActivePomProfiles() {
        if (this.declaredActivePomProfiles == null) {
            ArrayList<PomProfile> activeByDefaultPomProfiles = new ArrayList<PomProfile>();
            ArrayList<PomProfile> activeByAbsenceOfPropertyPomProfiles = new ArrayList<PomProfile>();
            Element profilesElement = PomDomParser.getFirstChildElement(this.projectElement, PROFILES);
            if (profilesElement != null) {
                for (Element profileElement : PomDomParser.getAllChilds(profilesElement)) {
                    Element activationElement;
                    if (!PROFILE.equals(profileElement.getNodeName()) || (activationElement = PomDomParser.getFirstChildElement(profileElement, PROFILE_ACTIVATION)) == null) continue;
                    String activeByDefault = PomDomParser.getFirstChildText(activationElement, PROFILE_ACTIVATION_ACTIVE_BY_DEFAULT);
                    if (activeByDefault != null && "true".equals(activeByDefault)) {
                        activeByDefaultPomProfiles.add(new PomProfileElement(profileElement));
                        continue;
                    }
                    Element propertyElement = PomDomParser.getFirstChildElement(activationElement, PROFILE_ACTIVATION_PROPERTY);
                    if (propertyElement == null || !this.isActivationPropertyActivated(propertyElement)) continue;
                    activeByAbsenceOfPropertyPomProfiles.add(new PomProfileElement(profileElement));
                }
            }
            this.declaredActivePomProfiles = this.determineActiveProfiles(activeByDefaultPomProfiles, activeByAbsenceOfPropertyPomProfiles);
        }
        return this.declaredActivePomProfiles;
    }

    private List<PomProfile> determineActiveProfiles(List<PomProfile> activeByDefaultPomProfiles, List<PomProfile> activeByAbsenceOfPropertyPomProfiles) {
        return !activeByAbsenceOfPropertyPomProfiles.isEmpty() ? activeByAbsenceOfPropertyPomProfiles : activeByDefaultPomProfiles;
    }

    private boolean isActivationPropertyActivated(Element propertyElement) {
        String propertyName = PomDomParser.getFirstChildText(propertyElement, LICENSE_NAME);
        return propertyName.startsWith("!");
    }

    public Map<String, String> getPomProperties() {
        return this.getPomProperties(this.projectElement);
    }

    private Map<String, String> getPomProperties(Element parentElement) {
        HashMap<String, String> pomProperties = new HashMap<String, String>();
        Element propsEl = PomDomParser.getFirstChildElement(parentElement, PROPERTIES);
        if (propsEl != null) {
            propsEl.normalize();
        }
        for (Element prop : PomDomParser.getAllChilds(propsEl)) {
            pomProperties.put(prop.getNodeName(), PomDomParser.getTextContent(prop));
        }
        return pomProperties;
    }

    private String replaceProps(String val) {
        if (val == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables((String)val, this.properties).trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PomProfileElement
    implements PomProfile {
        private final Element element;
        private List<PomDependencyMgt> declaredDependencyMgts;
        private List<PomDependencyData> declaredDependencies;

        PomProfileElement(Element element) {
            this.element = element;
        }

        @Override
        public String getId() {
            return PomDomParser.getFirstChildText(this.element, PomReader.PROFILE_ID);
        }

        @Override
        public Map<String, String> getProperties() {
            return PomReader.this.getPomProperties(this.element);
        }

        @Override
        public List<PomDependencyMgt> getDependencyMgts() {
            if (this.declaredDependencyMgts == null) {
                this.declaredDependencyMgts = PomReader.this.getDependencyMgt(this.element);
            }
            return this.declaredDependencyMgts;
        }

        @Override
        public List<PomDependencyData> getDependencies() {
            if (this.declaredDependencies == null) {
                this.declaredDependencies = PomReader.this.getDependencyData(this.element);
            }
            return this.declaredDependencies;
        }
    }

    public class PomDependencyData
    extends PomDependencyMgtElement {
        private final Element depElement;

        PomDependencyData(Element depElement) {
            super(depElement);
            this.depElement = depElement;
        }

        public boolean isOptional() {
            Element e = PomDomParser.getFirstChildElement(this.depElement, PomReader.OPTIONAL);
            return e != null && "true".equalsIgnoreCase(PomDomParser.getTextContent(e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PomDependencyMgtElement
    implements PomDependencyMgt {
        private final Element depElement;

        PomDependencyMgtElement(Element depElement) {
            this.depElement = depElement;
        }

        @Override
        public MavenDependencyKey getId() {
            return new MavenDependencyKey(this.getGroupId(), this.getArtifactId(), this.getType(), this.getClassifier());
        }

        @Override
        public String getGroupId() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.GROUP_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getArtifactId() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.ARTIFACT_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getVersion() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.VERSION);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getScope() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.SCOPE);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getType() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.TYPE);
            if ((val = PomReader.this.replaceProps(val)) == null) {
                val = "jar";
            }
            return val;
        }

        @Override
        public String getClassifier() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.CLASSIFIER);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public List<ModuleId> getExcludedModules() {
            Element exclusionsElement = PomDomParser.getFirstChildElement(this.depElement, PomReader.EXCLUSIONS);
            LinkedList<ModuleId> exclusions = new LinkedList<ModuleId>();
            if (exclusionsElement != null) {
                NodeList childs = exclusionsElement.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node node = childs.item(i);
                    if (!(node instanceof Element) || !PomReader.EXCLUSION.equals(node.getNodeName())) continue;
                    String groupId = PomDomParser.getFirstChildText((Element)node, PomReader.GROUP_ID);
                    String artifactId = PomDomParser.getFirstChildText((Element)node, PomReader.ARTIFACT_ID);
                    if (groupId == null || artifactId == null) continue;
                    exclusions.add(IvyUtil.createModuleId(groupId, artifactId));
                }
            }
            return exclusions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GavProperty {
        PARENT_VERSION("parent.version", "project.parent.version"),
        PARENT_GROUP_ID("parent.groupId", "project.parent.groupId"),
        GROUP_ID("project.groupId", "pom.groupId", "groupId"),
        ARTIFACT_ID("project.artifactId", "pom.artifactId", "artifactId"),
        VERSION("project.version", "pom.version", "version");

        private final String[] names;

        private GavProperty(String ... names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }
    }
}

