/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.AbstractVersionSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionRangeSelector
extends AbstractVersionSelector {
    private static final String OPEN_INC = "[";
    private static final String OPEN_EXC = "]";
    private static final String OPEN_EXC_MAVEN = "(";
    private static final String CLOSE_INC = "]";
    private static final String CLOSE_EXC = "[";
    private static final String CLOSE_EXC_MAVEN = ")";
    private static final String LOWER_INFINITE = "(";
    private static final String UPPER_INFINITE = ")";
    private static final String SEPARATOR = ",";
    private static final String OPEN_INC_PATTERN = "\\[";
    private static final String OPEN_EXC_PATTERN = "\\]\\(";
    private static final String CLOSE_INC_PATTERN = "\\]";
    private static final String CLOSE_EXC_PATTERN = "\\[\\)";
    private static final String LI_PATTERN = "\\(";
    private static final String UI_PATTERN = "\\)";
    private static final String SEP_PATTERN = "\\s*\\,\\s*";
    private static final String OPEN_PATTERN = "[\\[\\]\\(]";
    private static final String CLOSE_PATTERN = "[\\]\\[\\)]";
    private static final String ANY_NON_SPECIAL_PATTERN = "[^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]";
    private static final String FINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String LOWER_INFINITE_PATTERN = "\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String UPPER_INFINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)";
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    public static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private final String upperBound;
    private final boolean upperInclusive;
    private final String lowerBound;
    private final boolean lowerInclusive;
    private final Comparator<String> comparator;

    public VersionRangeSelector(String selector, Comparator<String> comparator) {
        super(selector);
        this.comparator = comparator;
        Matcher matcher = FINITE_RANGE.matcher(selector);
        if (matcher.matches()) {
            this.lowerBound = matcher.group(1);
            this.lowerInclusive = selector.startsWith("[");
            this.upperBound = matcher.group(2);
            this.upperInclusive = selector.endsWith("]");
        } else {
            matcher = LOWER_INFINITE_RANGE.matcher(selector);
            if (matcher.matches()) {
                this.lowerBound = null;
                this.lowerInclusive = true;
                this.upperBound = matcher.group(1);
                this.upperInclusive = selector.endsWith("]");
            } else {
                matcher = UPPER_INFINITE_RANGE.matcher(selector);
                if (matcher.matches()) {
                    this.lowerBound = matcher.group(1);
                    this.lowerInclusive = selector.startsWith("[");
                    this.upperBound = null;
                    this.upperInclusive = true;
                } else {
                    throw new IllegalArgumentException("Not a version range selector: " + selector);
                }
            }
        }
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean requiresMetadata() {
        return false;
    }

    @Override
    public boolean matchesUniqueVersion() {
        return false;
    }

    @Override
    public boolean accept(String candidate) {
        if (this.lowerBound != null && !this.isHigher(candidate, this.lowerBound, this.lowerInclusive)) {
            return false;
        }
        return this.upperBound == null || this.isLower(candidate, this.upperBound, this.upperInclusive);
    }

    private boolean isLower(String version1, String version2, boolean inclusive) {
        int result = this.comparator.compare(version1, version2);
        return result <= (inclusive ? 0 : -1);
    }

    private boolean isHigher(String version1, String version2, boolean inclusive) {
        int result = this.comparator.compare(version1, version2);
        return result >= (inclusive ? 0 : 1);
    }
}

