/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.HashMap;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationsToArtifactsConverter;
import org.gradle.internal.component.local.model.MutableLocalComponentMetaData;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationsToArtifactsConverter
implements ConfigurationsToArtifactsConverter {
    @Override
    public void addArtifacts(MutableLocalComponentMetaData metaData, Iterable<? extends Configuration> configurations) {
        ModuleVersionIdentifier id = metaData.getId();
        for (Configuration configuration : configurations) {
            for (PublishArtifact publishArtifact : configuration.getArtifacts()) {
                IvyArtifactName ivyArtifact = this.createIvyArtifact(publishArtifact, id);
                metaData.addArtifact(configuration.getName(), ivyArtifact, publishArtifact.getFile());
            }
        }
    }

    public IvyArtifactName createIvyArtifact(PublishArtifact publishArtifact, ModuleVersionIdentifier moduleVersionIdentifier) {
        String name;
        HashMap<String, String> extraAttributes = new HashMap<String, String>();
        if (GUtil.isTrue((Object)publishArtifact.getClassifier())) {
            extraAttributes.put("m:classifier", publishArtifact.getClassifier());
        }
        if (!GUtil.isTrue((Object)(name = publishArtifact.getName()))) {
            name = moduleVersionIdentifier.getName();
        }
        return new DefaultIvyArtifactName(name, publishArtifact.getType(), publishArtifact.getExtension(), extraAttributes);
    }
}

