/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import com.google.common.base.Objects;
import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleDependencySubstitution;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ProjectDependencySubstitution;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.DefaultDependencyResolveDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DependencySubstitutionsInternal;
import org.gradle.api.internal.notations.ModuleIdentiferNotationConverter;
import org.gradle.internal.Actions;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencySubstitutions
implements DependencySubstitutionsInternal {
    private final Set<Action<? super DependencySubstitution<? super ComponentSelector>>> substitutionRules;
    private final NotationParser<Object, ModuleIdentifier> moduleIdentifierNotationParser;
    private final NotationParser<Object, ProjectComponentIdentifier> projectIdentifierNotationParser;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;

    public DefaultDependencySubstitutions() {
        this(new LinkedHashSet<Action<? super DependencySubstitution<? super ComponentSelector>>>());
    }

    DefaultDependencySubstitutions(Set<Action<? super DependencySubstitution<? super ComponentSelector>>> substitutionRules) {
        this.substitutionRules = substitutionRules;
        this.moduleIdentifierNotationParser = DefaultDependencySubstitutions.createModuleIdentifierNotationParser();
        this.projectIdentifierNotationParser = DefaultDependencySubstitutions.createProjectIdentifierNotationParser();
    }

    @Override
    public Action<DependencySubstitution<ComponentSelector>> getDependencySubstitutionRule() {
        return Actions.composite(this.substitutionRules);
    }

    private void addRule(Action<? super DependencySubstitution<? super ComponentSelector>> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.substitutionRules.add(rule);
    }

    public DependencySubstitutions all(Action<? super DependencySubstitution<? super ComponentSelector>> rule) {
        this.addRule(rule);
        return this;
    }

    @Override
    public DependencySubstitutions allWithDependencyResolveDetails(Action<? super DependencyResolveDetails> rule) {
        this.addRule(new DependencyResolveDetailsWrapperAction(rule));
        return this;
    }

    public DependencySubstitutions all(Closure<?> action) {
        return this.all((Action<? super DependencySubstitution<? super ComponentSelector>>)ClosureBackedAction.of(action));
    }

    public DependencySubstitutions eachModule(Action<? super ModuleDependencySubstitution> rule) {
        return this.all(new TypeFilteringDependencySubstitutionAction<ModuleDependencySubstitution>(ModuleDependencySubstitution.class, rule));
    }

    public DependencySubstitutions eachModule(Closure<?> rule) {
        return this.eachModule((Action<? super ModuleDependencySubstitution>)ClosureBackedAction.of(rule));
    }

    public DependencySubstitutions withModule(Object id, Action<? super ModuleDependencySubstitution> rule) {
        ModuleIdentifier moduleId = (ModuleIdentifier)this.moduleIdentifierNotationParser.parseNotation(id);
        return this.all(new ModuleIdFilteringDependencySubstitutionAction(moduleId, rule));
    }

    public DependencySubstitutions withModule(Object id, Closure<?> action) {
        return this.withModule(id, (Action<? super ModuleDependencySubstitution>)ClosureBackedAction.of(action));
    }

    public DependencySubstitutions eachProject(Action<? super ProjectDependencySubstitution> rule) {
        return this.all(new TypeFilteringDependencySubstitutionAction<ProjectDependencySubstitution>(ProjectDependencySubstitution.class, rule));
    }

    public DependencySubstitutions eachProject(Closure<?> rule) {
        return this.eachProject((Action<? super ProjectDependencySubstitution>)ClosureBackedAction.of(rule));
    }

    public DependencySubstitutions withProject(Object id, Action<? super ProjectDependencySubstitution> rule) {
        ProjectComponentIdentifier componentId = (ProjectComponentIdentifier)this.projectIdentifierNotationParser.parseNotation(id);
        return this.all(new ProjectIdFilteringDependencySubstitutionAction(componentId, rule));
    }

    public DependencySubstitutions withProject(Object id, Closure<?> rule) {
        return this.withProject(id, (Action<? super ProjectDependencySubstitution>)ClosureBackedAction.of(rule));
    }

    @Override
    public void beforeChange(MutationValidator validator) {
        this.mutationValidator = validator;
    }

    @Override
    public DependencySubstitutionsInternal copy() {
        return new DefaultDependencySubstitutions(new LinkedHashSet<Action<? super DependencySubstitution<? super ComponentSelector>>>(this.substitutionRules));
    }

    private static NotationParser<Object, ModuleIdentifier> createModuleIdentifierNotationParser() {
        return NotationParserBuilder.toType(ModuleIdentifier.class).converter((NotationConverter)new ModuleIdentiferNotationConverter()).converter((NotationConverter)ModuleIdentifierMapNotationConverter.getInstance()).toComposite();
    }

    private static NotationParser<Object, ProjectComponentIdentifier> createProjectIdentifierNotationParser() {
        return NotationParserBuilder.toType(ProjectComponentIdentifier.class).fromCharSequence((NotationConverter)new ProjectPathConverter()).fromType(Project.class, (NotationConverter)new ProjectConverter()).toComposite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyResolveDetailsWrapperAction
    implements Action<DependencySubstitution<? extends ComponentSelector>> {
        private final Action<? super DependencyResolveDetails> delegate;

        public DependencyResolveDetailsWrapperAction(Action<? super DependencyResolveDetails> delegate) {
            this.delegate = delegate;
        }

        public void execute(DependencySubstitution<? extends ComponentSelector> substitution) {
            DefaultDependencyResolveDetails details = new DefaultDependencyResolveDetails((DependencySubstitutionInternal)substitution);
            this.delegate.execute((Object)details);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeFilteringDependencySubstitutionAction<T extends DependencySubstitution<?>>
    implements Action<DependencySubstitution<ComponentSelector>> {
        private final Class<T> type;
        private final Action<? super T> delegate;

        public TypeFilteringDependencySubstitutionAction(Class<T> type, Action<? super T> delegate) {
            this.type = type;
            this.delegate = delegate;
        }

        public void execute(DependencySubstitution<ComponentSelector> substitution) {
            if (this.type.isAssignableFrom(substitution.getClass())) {
                this.delegate.execute(substitution);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectIdFilteringDependencySubstitutionAction
    implements Action<DependencySubstitution<ComponentSelector>> {
        private final Action<? super ProjectDependencySubstitution> delegate;
        private final ProjectComponentIdentifier id;

        public ProjectIdFilteringDependencySubstitutionAction(ProjectComponentIdentifier id, Action<? super ProjectDependencySubstitution> delegate) {
            this.id = id;
            this.delegate = delegate;
        }

        public void execute(DependencySubstitution substitution) {
            ComponentSelector requested = substitution.getRequested();
            if (requested.matchesStrictly((ComponentIdentifier)this.id)) {
                this.delegate.execute((Object)((ProjectDependencySubstitution)substitution));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleIdFilteringDependencySubstitutionAction
    implements Action<DependencySubstitution<ComponentSelector>> {
        private final Action<? super ModuleDependencySubstitution> delegate;
        private final ModuleIdentifier id;

        public ModuleIdFilteringDependencySubstitutionAction(ModuleIdentifier id, Action<? super ModuleDependencySubstitution> delegate) {
            this.id = id;
            this.delegate = delegate;
        }

        public void execute(DependencySubstitution substitution) {
            ModuleComponentSelector requestedModule;
            ComponentSelector requested = substitution.getRequested();
            if (requested instanceof ModuleComponentSelector && Objects.equal((Object)(requestedModule = (ModuleComponentSelector)requested).getGroup(), (Object)this.id.getGroup()) && Objects.equal((Object)requestedModule.getModule(), (Object)this.id.getName())) {
                this.delegate.execute((Object)((ModuleDependencySubstitution)substitution));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectConverter
    implements NotationConverter<Project, ProjectComponentIdentifier> {
        private ProjectConverter() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Project objects, e.g. project(':api').");
        }

        public void convert(Project notation, NotationConvertResult<? super ProjectComponentIdentifier> result) throws TypeConversionException {
            result.converted((Object)DefaultProjectComponentIdentifier.newId(notation.getPath()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectPathConverter
    implements NotationConverter<String, ProjectComponentIdentifier> {
        private ProjectPathConverter() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Project paths, e.g. ':api'.");
        }

        public void convert(String notation, NotationConvertResult<? super ProjectComponentIdentifier> result) throws TypeConversionException {
            result.converted((Object)DefaultProjectComponentIdentifier.newId(notation));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleIdentifierMapNotationConverter
    extends MapNotationConverter<ModuleIdentifier> {
        private static final ModuleIdentifierMapNotationConverter INSTANCE = new ModuleIdentifierMapNotationConverter();

        private ModuleIdentifierMapNotationConverter() {
        }

        public static ModuleIdentifierMapNotationConverter getInstance() {
            return INSTANCE;
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Maps, e.g. [group: 'org.gradle', name:'gradle-core'].");
        }

        protected ModuleIdentifier parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name) {
            return DefaultModuleIdentifier.newId(group, name);
        }
    }
}

