/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.DefaultResolvedDependency;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.DefaultTransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedContentsMapping;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.cache.BinaryStore;
import org.gradle.api.internal.cache.Store;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientConfigurationResultsBuilder {
    private static final Logger LOG = Logging.getLogger(TransientConfigurationResultsBuilder.class);
    private static final byte NEW_DEP = 1;
    private static final byte ROOT = 2;
    private static final byte FIRST_LVL = 3;
    private static final byte PARENT_CHILD = 4;
    private static final byte PARENT_ARTIFACT = 5;
    private final Object lock = new Object();
    private BinaryStore binaryStore;
    private Store<TransientConfigurationResults> cache;
    private final ResolvedConfigurationIdentifierSerializer resolvedConfigurationIdentifierSerializer = new ResolvedConfigurationIdentifierSerializer();
    private BinaryStore.BinaryData binaryData;

    public TransientConfigurationResultsBuilder(BinaryStore binaryStore, Store<TransientConfigurationResults> cache) {
        this.binaryStore = binaryStore;
        this.cache = cache;
    }

    private void writeId(final byte type, final ResolvedConfigurationIdentifier ... ids) {
        this.binaryStore.write(new BinaryStore.WriteAction(){

            public void write(Encoder encoder) throws IOException {
                encoder.writeByte(type);
                for (ResolvedConfigurationIdentifier id : ids) {
                    TransientConfigurationResultsBuilder.this.resolvedConfigurationIdentifierSerializer.write(encoder, id);
                }
            }
        });
    }

    public void resolvedDependency(ResolvedConfigurationIdentifier id) {
        this.writeId((byte)1, id);
    }

    public void done(ResolvedConfigurationIdentifier id) {
        this.writeId((byte)2, id);
        LOG.debug("Flushing resolved configuration data in {}. Wrote root {}.", (Object)this.binaryStore, (Object)id);
        this.binaryData = this.binaryStore.done();
    }

    public void firstLevelDependency(ResolvedConfigurationIdentifier id) {
        this.writeId((byte)3, id);
    }

    public void parentChildMapping(ResolvedConfigurationIdentifier parent, ResolvedConfigurationIdentifier child) {
        this.writeId((byte)4, parent, child);
    }

    public void parentSpecificArtifact(ResolvedConfigurationIdentifier child, ResolvedConfigurationIdentifier parent, final long artifactId) {
        this.writeId((byte)5, child, parent);
        this.binaryStore.write(new BinaryStore.WriteAction(){

            public void write(Encoder encoder) throws IOException {
                encoder.writeLong(artifactId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientConfigurationResults load(final ResolvedContentsMapping mapping) {
        Object object = this.lock;
        synchronized (object) {
            return (TransientConfigurationResults)this.cache.load((Factory)new Factory<TransientConfigurationResults>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public TransientConfigurationResults create() {
                    try {
                        TransientConfigurationResults transientConfigurationResults = (TransientConfigurationResults)TransientConfigurationResultsBuilder.this.binaryData.read((BinaryStore.ReadAction)new BinaryStore.ReadAction<TransientConfigurationResults>(){

                            public TransientConfigurationResults read(Decoder decoder) throws IOException {
                                return TransientConfigurationResultsBuilder.this.deserialize(decoder, mapping);
                            }
                        });
                        return transientConfigurationResults;
                    }
                    finally {
                        try {
                            TransientConfigurationResultsBuilder.this.binaryData.close();
                        }
                        catch (IOException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TransientConfigurationResults deserialize(Decoder decoder, ResolvedContentsMapping mapping) {
        Clock clock = new Clock();
        HashMap<ResolvedConfigurationIdentifier, DefaultResolvedDependency> allDependencies = new HashMap<ResolvedConfigurationIdentifier, DefaultResolvedDependency>();
        DefaultTransientConfigurationResults results = new DefaultTransientConfigurationResults();
        int valuesRead = 0;
        int type = -1;
        try {
            block9: while (true) {
                type = decoder.readByte();
                ++valuesRead;
                switch (type) {
                    case 1: {
                        ResolvedConfigurationIdentifier id = this.resolvedConfigurationIdentifierSerializer.read(decoder);
                        allDependencies.put(id, new DefaultResolvedDependency(id.getId(), id.getConfiguration()));
                        continue block9;
                    }
                    case 2: {
                        ResolvedConfigurationIdentifier id = this.resolvedConfigurationIdentifierSerializer.read(decoder);
                        results.root = (ResolvedDependency)allDependencies.get(id);
                        if (results.root == null) {
                            throw new IllegalStateException(String.format("Unexpected root id %s. Seen ids: %s", id, allDependencies.keySet()));
                        }
                        LOG.debug("Loaded resolved configuration results ({}) from {}", (Object)clock.getTime(), (Object)this.binaryStore);
                        return results;
                    }
                    case 3: {
                        ResolvedConfigurationIdentifier id = this.resolvedConfigurationIdentifierSerializer.read(decoder);
                        DefaultResolvedDependency dependency = (DefaultResolvedDependency)allDependencies.get(id);
                        if (dependency == null) {
                            throw new IllegalStateException(String.format("Unexpected first level id %s. Seen ids: %s", id, allDependencies.keySet()));
                        }
                        results.firstLevelDependencies.put(mapping.getModuleDependency(id), dependency);
                        continue block9;
                    }
                    case 4: {
                        ResolvedConfigurationIdentifier parentId = this.resolvedConfigurationIdentifierSerializer.read(decoder);
                        ResolvedConfigurationIdentifier childId = this.resolvedConfigurationIdentifierSerializer.read(decoder);
                        DefaultResolvedDependency parent = (DefaultResolvedDependency)allDependencies.get(parentId);
                        DefaultResolvedDependency child = (DefaultResolvedDependency)allDependencies.get(childId);
                        if (parent == null) {
                            throw new IllegalStateException(String.format("Unexpected parent dependency id %s. Seen ids: %s", parentId, allDependencies.keySet()));
                        }
                        if (child == null) {
                            throw new IllegalStateException(String.format("Unexpected child dependency id %s. Seen ids: %s", childId, allDependencies.keySet()));
                        }
                        parent.addChild(child);
                        continue block9;
                    }
                    case 5: {
                        ResolvedConfigurationIdentifier artifactParentId = this.resolvedConfigurationIdentifierSerializer.read(decoder);
                        ResolvedConfigurationIdentifier artifactChildId = this.resolvedConfigurationIdentifierSerializer.read(decoder);
                        DefaultResolvedDependency artifactParent = (DefaultResolvedDependency)allDependencies.get(artifactParentId);
                        DefaultResolvedDependency artifactChild = (DefaultResolvedDependency)allDependencies.get(artifactChildId);
                        if (artifactParent == null) {
                            throw new IllegalStateException(String.format("Unexpected parent dependency id %s. Seen ids: %s", artifactParentId, allDependencies.keySet()));
                        }
                        if (artifactChild == null) {
                            throw new IllegalStateException(String.format("Unexpected child dependency id %s. Seen ids: %s", artifactChildId, allDependencies.keySet()));
                        }
                        artifactParent.addParentSpecificArtifacts(artifactChild, Sets.newHashSet((Object[])new ResolvedArtifact[]{mapping.getArtifact(decoder.readLong())}));
                        continue block9;
                    }
                }
                break;
            }
            throw new IOException("Unknown value type read from stream: " + type);
        }
        catch (IOException e) {
            throw new RuntimeException("Problems loading the resolved configuration. Read " + valuesRead + " values, last was: " + type, e);
        }
    }
}

