/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.AwsCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.repositories.AbstractArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultPasswordCredentials;
import org.gradle.internal.Cast;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.internal.credentials.DefaultAwsCredentials;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticationSupportedRepository
extends AbstractArtifactRepository
implements AuthenticationSupportedInternal {
    private Credentials credentials;
    private final Instantiator instantiator;

    AbstractAuthenticationSupportedRepository(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public PasswordCredentials getCredentials() {
        if (this.credentials == null) {
            return this.setCredentials(PasswordCredentials.class);
        }
        if (this.credentials instanceof PasswordCredentials) {
            return (PasswordCredentials)Cast.uncheckedCast((Object)this.credentials);
        }
        throw new IllegalStateException("Can not use getCredentials() method when not using PasswordCredentals; please use getCredentials(Class)");
    }

    public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
        if (this.credentials == null) {
            return this.setCredentials(credentialsType);
        }
        if (credentialsType.isInstance(this.credentials)) {
            return (T)((Credentials)Cast.uncheckedCast((Object)this.credentials));
        }
        throw new IllegalArgumentException(String.format("Given credentials type '%s' does not match actual type '%s'", credentialsType.getName(), AbstractAuthenticationSupportedRepository.getPublicType(this.credentials.getClass()).getName()));
    }

    public void credentials(Action<? super PasswordCredentials> action) {
        if (this.credentials != null && !(this.credentials instanceof PasswordCredentials)) {
            throw new IllegalStateException("Can not use credentials(Action) method when not using PasswordCredentals; please use credentials(Class, Action)");
        }
        this.credentials(PasswordCredentials.class, action);
    }

    public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) throws IllegalStateException {
        action.execute(this.getCredentials(credentialsType));
    }

    private <T extends Credentials> T setCredentials(Class<T> clazz) {
        T t = this.newCredentials(clazz);
        this.credentials = t;
        return t;
    }

    private <T extends Credentials> T newCredentials(Class<T> clazz) {
        return (T)((Credentials)this.instantiator.newInstance(AbstractAuthenticationSupportedRepository.getImplType(clazz), new Object[0]));
    }

    public Credentials getConfiguredCredentials() {
        return this.credentials;
    }

    private static <T extends Credentials> Class<? extends T> getImplType(Class<T> publicType) {
        if (publicType == PasswordCredentials.class) {
            return (Class)Cast.uncheckedCast(DefaultPasswordCredentials.class);
        }
        if (publicType == AwsCredentials.class) {
            return (Class)Cast.uncheckedCast(DefaultAwsCredentials.class);
        }
        throw new IllegalArgumentException(String.format("Unknown credentials type: '%s' (supported types: %s and %s).", publicType.getName(), PasswordCredentials.class.getName(), AwsCredentials.class.getName()));
    }

    private static <T extends Credentials> Class<? super T> getPublicType(Class<T> implType) {
        if (PasswordCredentials.class.isAssignableFrom(implType)) {
            return (Class)Cast.uncheckedCast(PasswordCredentials.class);
        }
        if (AwsCredentials.class.isAssignableFrom(implType)) {
            return (Class)Cast.uncheckedCast(AwsCredentials.class);
        }
        throw new IllegalArgumentException(String.format("Unknown credentials implementation type: '%s' (supported types: %s and %s).", implType.getName(), DefaultPasswordCredentials.class.getName(), DefaultAwsCredentials.class.getName()));
    }
}

