/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.repositories.AbstractAuthenticationSupportedRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.component.external.model.DefaultMavenModuleResolveMetaData;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenArtifactRepository
extends AbstractAuthenticationSupportedRepository
implements MavenArtifactRepository,
ResolutionAwareRepository,
PublicationAwareRepository {
    private final FileResolver fileResolver;
    private final RepositoryTransportFactory transportFactory;
    private Object url;
    private List<Object> additionalUrls = new ArrayList<Object>();
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetaData> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactMetaData> artifactFileStore;
    private final MetaDataParser<DefaultMavenModuleResolveMetaData> pomParser;

    public DefaultMavenArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetaData> locallyAvailableResourceFinder, Instantiator instantiator, FileStore<ModuleComponentArtifactMetaData> artifactFileStore, MetaDataParser<DefaultMavenModuleResolveMetaData> pomParser) {
        super(instantiator);
        this.fileResolver = fileResolver;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.pomParser = pomParser;
    }

    public URI getUrl() {
        return this.url == null ? null : this.fileResolver.resolveUri(this.url);
    }

    public void setUrl(Object url) {
        this.url = url;
    }

    public Set<URI> getArtifactUrls() {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        for (Object additionalUrl : this.additionalUrls) {
            result.add(this.fileResolver.resolveUri(additionalUrl));
        }
        return result;
    }

    public void artifactUrls(Object ... urls) {
        this.additionalUrls.addAll(Lists.newArrayList((Object[])urls));
    }

    public void setArtifactUrls(Iterable<?> urls) {
        this.additionalUrls = Lists.newArrayList(urls);
    }

    @Override
    public ModuleVersionPublisher createPublisher() {
        return this.createRealResolver();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    protected MavenResolver createRealResolver() {
        URI rootUri = this.getUrl();
        if (rootUri == null) {
            throw new InvalidUserDataException("You must specify a URL for a Maven repository.");
        }
        MavenResolver resolver = this.createResolver(rootUri);
        for (URI repoUrl : this.getArtifactUrls()) {
            resolver.addArtifactLocation(repoUrl);
        }
        return resolver;
    }

    private MavenResolver createResolver(URI rootUri) {
        RepositoryTransport transport = this.getTransport(rootUri.getScheme());
        return new MavenResolver(this.getName(), rootUri, transport, this.locallyAvailableResourceFinder, this.artifactFileStore, this.pomParser);
    }

    public MetaDataParser<DefaultMavenModuleResolveMetaData> getPomParser() {
        return this.pomParser;
    }

    protected FileStore<ModuleComponentArtifactMetaData> getArtifactFileStore() {
        return this.artifactFileStore;
    }

    protected RepositoryTransport getTransport(String scheme) {
        return this.transportFactory.createTransport(scheme, this.getName(), this.getConfiguredCredentials());
    }

    protected LocallyAvailableResourceFinder<ModuleComponentArtifactMetaData> getLocallyAvailableResourceFinder() {
        return this.locallyAvailableResourceFinder;
    }
}

