/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetaData;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;

class MavenUniqueSnapshotExternalResourceArtifactResolver
implements ExternalResourceArtifactResolver {
    private final ExternalResourceArtifactResolver delegate;
    private final String timestamp;

    public MavenUniqueSnapshotExternalResourceArtifactResolver(ExternalResourceArtifactResolver delegate, String timestamp) {
        this.delegate = delegate;
        this.timestamp = timestamp;
    }

    public boolean artifactExists(ModuleComponentArtifactMetaData artifact, ResourceAwareResolveResult result) {
        return this.delegate.artifactExists(this.timestamp(artifact), result);
    }

    public LocallyAvailableExternalResource resolveArtifact(ModuleComponentArtifactMetaData artifact, ResourceAwareResolveResult result) {
        return this.delegate.resolveArtifact(this.timestamp(artifact), result);
    }

    public LocallyAvailableExternalResource resolveMetaDataArtifact(ModuleComponentArtifactMetaData artifact, ResourceAwareResolveResult result) {
        return this.delegate.resolveMetaDataArtifact(this.timestamp(artifact), result);
    }

    protected ModuleComponentArtifactMetaData timestamp(ModuleComponentArtifactMetaData artifact) {
        MavenUniqueSnapshotComponentIdentifier snapshotComponentIdentifier = new MavenUniqueSnapshotComponentIdentifier(artifact.getId().getComponentIdentifier(), this.timestamp);
        return new DefaultModuleComponentArtifactMetaData((ModuleComponentIdentifier)snapshotComponentIdentifier, artifact.getName());
    }
}

