/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.transport;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.ResourceConnectorRepositoryTransport;
import org.gradle.internal.resource.transport.file.FileTransport;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.util.BuildCommencedTimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTransportFactory {
    private final List<ResourceConnectorFactory> registeredProtocols = Lists.newArrayList();
    private final TemporaryFileProvider temporaryFileProvider;
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final BuildCommencedTimeProvider timeProvider;
    private final CacheLockingManager cacheLockingManager;

    public RepositoryTransportFactory(Collection<ResourceConnectorFactory> resourceConnectorFactory, ProgressLoggerFactory progressLoggerFactory, TemporaryFileProvider temporaryFileProvider, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.temporaryFileProvider = temporaryFileProvider;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
        this.timeProvider = timeProvider;
        this.cacheLockingManager = cacheLockingManager;
        for (ResourceConnectorFactory connectorFactory : resourceConnectorFactory) {
            this.register(connectorFactory);
        }
    }

    public void register(ResourceConnectorFactory resourceConnectorFactory) {
        this.registeredProtocols.add(resourceConnectorFactory);
    }

    public Set<String> getRegisteredProtocols() {
        LinkedHashSet validSchemes = Sets.newLinkedHashSet();
        validSchemes.add("file");
        for (ResourceConnectorFactory registeredProtocol : this.registeredProtocols) {
            validSchemes.addAll(registeredProtocol.getSupportedProtocols());
        }
        return validSchemes;
    }

    public RepositoryTransport createTransport(String scheme, String name, Credentials credentials) {
        return this.createTransport(Collections.singleton(scheme), name, credentials);
    }

    private PasswordCredentials convertPasswordCredentials(Credentials credentials) {
        if (!(credentials instanceof org.gradle.api.artifacts.repositories.PasswordCredentials)) {
            throw new IllegalArgumentException(String.format("Credentials must be an instance of: %s", org.gradle.api.artifacts.repositories.PasswordCredentials.class.getCanonicalName()));
        }
        org.gradle.api.artifacts.repositories.PasswordCredentials passwordCredentials = (org.gradle.api.artifacts.repositories.PasswordCredentials)credentials;
        return new PasswordCredentials(passwordCredentials.getUsername(), passwordCredentials.getPassword());
    }

    public RepositoryTransport createTransport(Set<String> schemes, String name, Credentials credentials) {
        this.validateSchemes(schemes);
        if (Collections.singleton("file").containsAll(schemes)) {
            return new FileTransport(name);
        }
        DefaultResourceConnectorSpecification connectionDetails = new DefaultResourceConnectorSpecification(credentials);
        ExternalResourceConnector resourceConnector = this.findConnectorFactory(schemes).createResourceConnector((ResourceConnectorSpecification)connectionDetails);
        return new ResourceConnectorRepositoryTransport(name, this.progressLoggerFactory, this.temporaryFileProvider, this.cachedExternalResourceIndex, this.timeProvider, this.cacheLockingManager, resourceConnector);
    }

    private void validateSchemes(Set<String> schemes) {
        Set<String> validSchemes = this.getRegisteredProtocols();
        for (String scheme : schemes) {
            if (validSchemes.contains(scheme)) continue;
            throw new InvalidUserDataException(String.format("Not a supported repository protocol '%s': valid protocols are %s", scheme, validSchemes));
        }
    }

    private ResourceConnectorFactory findConnectorFactory(Set<String> schemes) {
        for (ResourceConnectorFactory protocolRegistration : this.registeredProtocols) {
            if (!protocolRegistration.getSupportedProtocols().containsAll(schemes)) continue;
            return protocolRegistration;
        }
        throw new InvalidUserDataException("You cannot mix different URL schemes for a single repository. Please declare separate repositories.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultResourceConnectorSpecification
    implements ResourceConnectorSpecification {
        private final Credentials credentials;

        private DefaultResourceConnectorSpecification(Credentials credentials) {
            this.credentials = credentials;
        }

        public <T> T getCredentials(Class<T> type) {
            if (this.credentials == null) {
                return null;
            }
            if (PasswordCredentials.class.isAssignableFrom(type)) {
                return type.cast(RepositoryTransportFactory.this.convertPasswordCredentials(this.credentials));
            }
            if (type.isAssignableFrom(this.credentials.getClass())) {
                return type.cast(this.credentials);
            }
            throw new IllegalArgumentException(String.format("Credentials must be an instance of '%s'.", type.getCanonicalName()));
        }
    }
}

