/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.TypedNotationConverter;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleIdentiferNotationConverter
extends TypedNotationConverter<String, ModuleIdentifier> {
    private static final List<Character> INVALID_SPEC_CHARS = Lists.newArrayList((Object[])new Character[]{Character.valueOf('*'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(','), Character.valueOf('+')});

    public ModuleIdentiferNotationConverter() {
        super(String.class);
    }

    protected ModuleIdentifier parseType(String notation) {
        assert (notation != null);
        String[] split = notation.split(":");
        if (split.length != 2) {
            throw new UnsupportedNotationException((Object)notation);
        }
        String group = split[0].trim();
        String name = split[1].trim();
        if (group.length() == 0 || name.length() == 0) {
            throw new UnsupportedNotationException((Object)notation);
        }
        for (char c : INVALID_SPEC_CHARS) {
            if (group.indexOf(c) == -1 && name.indexOf(c) == -1) continue;
            throw new UnsupportedNotationException((Object)notation);
        }
        return DefaultModuleIdentifier.newId(group, name);
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("String describing the module in 'group:name' format").example("'org.gradle:gradle-core'.");
    }
}

