/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.component.external.model.DefaultIvyModuleResolveMetaData;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildableIvyModuleResolveMetaData
extends DefaultIvyModuleResolveMetaData {
    private final DefaultModuleDescriptor module;

    public BuildableIvyModuleResolveMetaData(DefaultModuleDescriptor module) {
        super((ModuleDescriptor)module);
        this.module = module;
    }

    public void addArtifact(IvyArtifactName newArtifact, Set<String> configurations) {
        Artifact[] allArtifacts;
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("Artifact should be attached to at least one configuration.");
        }
        MDArtifact unattached = new MDArtifact((ModuleDescriptor)this.module, newArtifact.getName(), newArtifact.getType(), newArtifact.getExtension(), null, newArtifact.getAttributes());
        for (Artifact existing : allArtifacts = this.module.getAllArtifacts()) {
            if (!this.artifactsEqual((Artifact)unattached, existing)) continue;
            if (!(existing instanceof MDArtifact)) {
                throw new IllegalArgumentException("Cannot update an existing artifact (" + existing + ") in provided module descriptor (" + this.module + ")" + " because the artifact is not an instance of MDArtifact." + this.module);
            }
            BuildableIvyModuleResolveMetaData.attachArtifact((MDArtifact)existing, configurations, this.module);
            return;
        }
        BuildableIvyModuleResolveMetaData.attachArtifact(unattached, configurations, this.module);
    }

    private boolean artifactsEqual(Artifact a, Artifact b) {
        return new DefaultIvyArtifactName(a).equals(new DefaultIvyArtifactName(b));
    }

    private static void attachArtifact(MDArtifact artifact, Set<String> configurations, DefaultModuleDescriptor target) {
        LinkedHashSet existingConfigurations = Sets.newLinkedHashSet(Arrays.asList(artifact.getConfigurations()));
        for (String c : configurations) {
            if (existingConfigurations.contains(c)) continue;
            artifact.addConfiguration(c);
            target.addArtifact(c, (Artifact)artifact);
        }
    }
}

