/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.internal.component.external.model.BuildableIvyModulePublishMetaData;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.IvyModuleArtifactPublishMetaData;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIvyModulePublishMetaData
implements BuildableIvyModulePublishMetaData {
    private final ModuleVersionIdentifier id;
    private final Map<ModuleComponentArtifactIdentifier, IvyModuleArtifactPublishMetaData> artifactsById = new LinkedHashMap<ModuleComponentArtifactIdentifier, IvyModuleArtifactPublishMetaData>();

    public DefaultIvyModulePublishMetaData(ModuleVersionIdentifier id) {
        this.id = id;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public void addArtifact(Artifact artifact, File file) {
        DefaultIvyModuleArtifactPublishMetaData publishMetaData = new DefaultIvyModuleArtifactPublishMetaData(this.id, artifact, file);
        this.artifactsById.put(publishMetaData.getId(), publishMetaData);
    }

    @Override
    public void addArtifact(IvyModuleArtifactPublishMetaData artifact) {
        this.artifactsById.put(artifact.getId(), artifact);
    }

    @Override
    public Collection<IvyModuleArtifactPublishMetaData> getArtifacts() {
        return this.artifactsById.values();
    }

    public IvyModuleArtifactPublishMetaData getArtifact(ModuleComponentArtifactIdentifier artifactIdentifier) {
        return this.artifactsById.get(artifactIdentifier);
    }

    private static class DefaultIvyModuleArtifactPublishMetaData
    implements IvyModuleArtifactPublishMetaData {
        private final DefaultModuleComponentArtifactIdentifier id;
        private final Artifact artifact;
        private final File file;

        private DefaultIvyModuleArtifactPublishMetaData(ModuleVersionIdentifier moduleVersionIdentifier, Artifact artifact, File file) {
            this.id = new DefaultModuleComponentArtifactIdentifier(DefaultModuleComponentIdentifier.newId(moduleVersionIdentifier), artifact);
            this.artifact = artifact;
            this.file = file;
        }

        public IvyArtifactName getArtifactName() {
            return this.id.getName();
        }

        public Artifact toIvyArtifact() {
            return this.artifact;
        }

        public ModuleComponentArtifactIdentifier getId() {
            return this.id;
        }

        public File getFile() {
            return this.file;
        }
    }
}

