/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableComponentResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentResolveResult {
    private ComponentResolveMetaData metaData;
    private ModuleVersionResolveException failure;

    public DefaultBuildableComponentResolveResult failed(ModuleVersionResolveException failure) {
        this.metaData = null;
        this.failure = failure;
        return this;
    }

    public void notFound(ModuleVersionIdentifier versionIdentifier) {
        this.failed(new ModuleVersionNotFoundException(versionIdentifier, this.getAttempted()));
    }

    public void resolved(ComponentResolveMetaData metaData) {
        this.metaData = metaData;
    }

    public void setMetaData(ComponentResolveMetaData metaData) {
        this.assertResolved();
        this.metaData = metaData;
    }

    public ModuleVersionIdentifier getId() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData.getId();
    }

    public ComponentResolveMetaData getMetaData() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData;
    }

    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }

    public boolean hasResult() {
        return this.failure != null || this.metaData != null;
    }

    public void applyTo(BuildableComponentIdResolveResult idResolve) {
        super.applyTo(idResolve);
        if (this.failure != null) {
            idResolve.failed(this.failure);
        }
        if (this.metaData != null) {
            idResolve.resolved(this.metaData);
        }
    }
}

