/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class StringHelper {
    public static String capitalize(String string) {
        StringBuilder sb = new StringBuilder();
        sb.append(string.substring(0, 1).toUpperCase(Locale.US)).append(string.substring(1));
        return sb.toString();
    }

    public static String combineAsCamelCase(Iterable<String> stringList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : stringList) {
            if (first) {
                sb.append(str);
                first = false;
                continue;
            }
            sb.append(StringHelper.capitalize(str));
        }
        return sb.toString();
    }

    public static List<String> toStrings(Object ... objects) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object path : objects) {
            if (path instanceof String) {
                builder.add((Object)((String)path));
                continue;
            }
            if (path instanceof Collection) {
                Collection pathCollection = (Collection)path;
                for (Object item : pathCollection) {
                    if (item instanceof String) {
                        builder.add((Object)((String)item));
                        continue;
                    }
                    builder.add((Object)path.toString());
                }
                continue;
            }
            builder.add((Object)path.toString());
        }
        return builder.build();
    }

    public static void appendCamelCase(StringBuilder sb, String word) {
        if (word != null) {
            if (sb.length() == 0) {
                sb.append(word);
            } else {
                sb.append(StringHelper.capitalize(word));
            }
        }
    }
}

