/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.template.GroovyTemplateContextType;

public class GroovyStructuralSearchProfile
extends StructuralSearchProfileBase {
    public static final String FILE_CONTEXT = "File";
    public static final String CLASS_CONTEXT = "Class";
    private static final TokenSet VARIABLE_DELIMETERS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mCOMMA, GroovyTokenTypes.mSEMI});

    protected String[] getVarPrefixes() {
        return new String[]{"_$_____"};
    }

    public String[] getContextNames() {
        return new String[]{FILE_CONTEXT, CLASS_CONTEXT};
    }

    protected LanguageFileType getFileType() {
        return GroovyFileType.GROOVY_FILE_TYPE;
    }

    protected TokenSet getVariableDelimiters() {
        return VARIABLE_DELIMETERS;
    }

    public PsiCodeFragment createCodeFragment(Project project, String text, PsiElement context) {
        GroovyCodeFragment result = new GroovyCodeFragment(project, text);
        result.setContext(context);
        return result;
    }

    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return GroovyTemplateContextType.class;
    }

    public String getContext(String pattern, Language language, String contextName) {
        return CLASS_CONTEXT.equals(contextName) ? "class AAAAA { $$PATTERN_PLACEHOLDER$$ }" : "$$PATTERN_PLACEHOLDER$$";
    }

    public Class getElementContextByPsi(PsiElement element) {
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (element instanceof PsiMember) {
            return PsiMember.class;
        }
        return PsiExpression.class;
    }

    public boolean isIdentifier(PsiElement element) {
        return element instanceof PsiIdentifier;
    }
}

