/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.injected.JavaConcatenationInjectorManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;

public class GrConcatenation2InjectorAdapter
extends JavaConcatenationInjectorManager.BaseConcatenation2InjectorAdapter
implements MultiHostInjector {
    private static final List<Class<? extends GrLiteralContainer>> LITERALS = Arrays.asList(GrLiteral.class, GrStringContent.class);

    public GrConcatenation2InjectorAdapter(Project project) {
        super(project);
    }

    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return LITERALS;
    }

    protected Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(PsiElement context) {
        PsiElement anchor;
        PsiElement[] operands;
        PsiElement element = context;
        PsiElement parent = context.getParent();
        while (parent instanceof GrBinaryExpression && ((GrBinaryExpression)parent).getOperationTokenType() == GroovyTokenTypes.mPLUS || parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getOperationToken() == GroovyTokenTypes.mPLUS_ASSIGN || parent instanceof GrConditionalExpression && ((GrConditionalExpression)parent).getCondition() != element || parent instanceof GrTypeCastExpression || parent instanceof GrSafeCastExpression || parent instanceof GrParenthesizedExpression || parent instanceof GrString) {
            element = parent;
            parent = parent.getParent();
        }
        if (element instanceof GrBinaryExpression) {
            operands = GrConcatenation2InjectorAdapter.collectBinaryOperands((GrBinaryExpression)element);
            anchor = element;
        } else if (element instanceof GrString) {
            operands = GrConcatenation2InjectorAdapter.collectGStringOperands((GrString)element);
            anchor = element;
        } else if (element instanceof GrAssignmentExpression) {
            GrExpression rvalue = ((GrAssignmentExpression)element).getRValue();
            operands = new PsiElement[]{rvalue == null ? element : rvalue};
            anchor = element;
        } else {
            operands = new PsiElement[]{context};
            anchor = context;
        }
        return Pair.create((Object)anchor, (Object)operands);
    }

    private static PsiElement[] collectGStringOperands(GrString grString) {
        ArrayList operands = ContainerUtil.newArrayList();
        GrConcatenation2InjectorAdapter.processGString(grString, operands);
        return operands.toArray(new PsiElement[operands.size()]);
    }

    private static void processGString(GrString string, ArrayList<PsiElement> operands) {
        ContainerUtil.addAll(operands, (Object[])string.getAllContentParts());
    }

    private static PsiElement[] collectBinaryOperands(GrBinaryExpression expression) {
        ArrayList operands = ContainerUtil.newArrayList();
        GrConcatenation2InjectorAdapter.processBinary(expression, operands);
        return operands.toArray(new PsiElement[operands.size()]);
    }

    private static void processBinary(GrBinaryExpression expression, ArrayList<PsiElement> operands) {
        GrExpression left = expression.getLeftOperand();
        GrExpression right = expression.getRightOperand();
        if (left instanceof GrBinaryExpression) {
            GrConcatenation2InjectorAdapter.processBinary((GrBinaryExpression)left, operands);
        } else if (left instanceof GrString) {
            GrConcatenation2InjectorAdapter.processGString((GrString)left, operands);
        } else {
            operands.add(left);
        }
        if (right instanceof GrBinaryExpression) {
            GrConcatenation2InjectorAdapter.processBinary((GrBinaryExpression)right, operands);
        } else if (right instanceof GrString) {
            GrConcatenation2InjectorAdapter.processGString((GrString)right, operands);
        } else if (right != null) {
            operands.add(right);
        }
    }
}

