/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

class AliasedAnnotationHolder
implements AnnotationHolder {
    private final AnnotationHolder myHolder;
    private final GrAnnotation myAlias;
    private final GrCodeReferenceElement myReference;

    public AliasedAnnotationHolder(AnnotationHolder holder, GrAnnotation alias) {
        this.myHolder = holder;
        this.myAlias = alias;
        this.myReference = this.myAlias.getClassReference();
    }

    private PsiElement findCodeElement(PsiElement elt) {
        if (PsiTreeUtil.isAncestor((PsiElement)this.myAlias, (PsiElement)elt, (boolean)true)) {
            return elt;
        }
        return this.myReference;
    }

    public Annotation createErrorAnnotation(PsiElement elt, String message) {
        PsiElement codeElement = this.findCodeElement(elt);
        return this.myHolder.createErrorAnnotation(codeElement, message);
    }

    public Annotation createErrorAnnotation(ASTNode node, String message) {
        return this.createErrorAnnotation(node.getPsi(), message);
    }

    public Annotation createErrorAnnotation(TextRange range, String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createWarningAnnotation(PsiElement elt, String message) {
        return this.myHolder.createWarningAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createWarningAnnotation(ASTNode node, String message) {
        return this.myHolder.createWarningAnnotation(node.getPsi(), message);
    }

    public Annotation createWarningAnnotation(TextRange range, String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createWeakWarningAnnotation(PsiElement elt, String message) {
        return this.myHolder.createWeakWarningAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createWeakWarningAnnotation(ASTNode node, String message) {
        return this.myHolder.createWarningAnnotation(node.getPsi(), message);
    }

    public Annotation createWeakWarningAnnotation(TextRange range, String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createInfoAnnotation(PsiElement elt, String message) {
        return this.myHolder.createInfoAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createInfoAnnotation(ASTNode node, String message) {
        return this.myHolder.createInfoAnnotation(node.getPsi(), message);
    }

    public Annotation createInfoAnnotation(TextRange range, String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createAnnotation(HighlightSeverity severity, TextRange range, String message) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createAnnotation(HighlightSeverity severity, TextRange range, String message, String htmlTooltip) {
        throw new UnsupportedOperationException("unsupported");
    }

    public AnnotationSession getCurrentAnnotationSession() {
        return this.myHolder.getCurrentAnnotationSession();
    }

    public boolean isBatchMode() {
        return this.myHolder.isBatchMode();
    }
}

