/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateMethodFromUsageFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CreateSetterFromUsageFix
extends CreateMethodFromUsageFix
implements LowPriorityAction {
    public CreateSetterFromUsageFix(GrReferenceExpression refExpression) {
        super(refExpression);
    }

    @Override
    protected TypeConstraint[] getReturnTypeConstraints() {
        return new TypeConstraint[]{SubtypeConstraint.create((PsiType)PsiType.VOID)};
    }

    @Override
    protected PsiType[] getArgumentTypes() {
        GrReferenceExpression ref = this.getRefExpr();
        assert (PsiUtil.isLValue(ref));
        PsiType initializer = TypeInferenceHelper.getInitializerTypeFor(ref);
        if (initializer == null || initializer == PsiType.NULL) {
            initializer = TypesUtil.getJavaLangObject(ref);
        }
        return new PsiType[]{initializer};
    }

    @Override
    protected String getMethodName() {
        return GroovyPropertyUtils.getSetterName(this.getRefExpr().getReferenceName());
    }
}

