/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrDisjunctionTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrRemoveExceptionFix
implements IntentionAction {
    private final String myText;
    private final boolean myDisjunction;

    public GrRemoveExceptionFix(boolean isDisjunction) {
        this.myDisjunction = isDisjunction;
        this.myText = isDisjunction ? GroovyIntentionsBundle.message("remove.exception", new Object[0]) : GroovyIntentionsBundle.message("remove.catch.block", new Object[0]);
    }

    public String getText() {
        return this.myText;
    }

    public String getFamilyName() {
        return GroovyIntentionsBundle.message("try.catch.fix", new Object[0]);
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        return this.myDisjunction && GrRemoveExceptionFix.findTypeElementInDisjunction(editor, file) != null || !this.myDisjunction && GrRemoveExceptionFix.findCatch(editor, file) != null;
    }

    private static GrTypeElement findTypeElementInDisjunction(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        GrDisjunctionTypeElement disjunction = (GrDisjunctionTypeElement)PsiTreeUtil.getParentOfType((PsiElement)at, GrDisjunctionTypeElement.class);
        if (disjunction == null) {
            return null;
        }
        for (GrTypeElement element : disjunction.getTypeElements()) {
            if (!element.getTextRange().contains(offset)) continue;
            return element;
        }
        return null;
    }

    private static GrCatchClause findCatch(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        return (GrCatchClause)PsiTreeUtil.getParentOfType((PsiElement)at, GrCatchClause.class);
    }

    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (this.myDisjunction) {
            GrTypeElement element = GrRemoveExceptionFix.findTypeElementInDisjunction(editor, file);
            if (element != null) {
                element.delete();
            }
        } else {
            GrCatchClause aCatch = GrRemoveExceptionFix.findCatch(editor, file);
            if (aCatch != null) {
                aCatch.delete();
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

