/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public abstract class BaseInspection
extends GroovySuppressableInspectionTool {
    private final String m_shortName = InspectionProfileEntry.getShortName((String)((Object)((Object)this)).getClass().getSimpleName());
    public static final String ASSIGNMENT_ISSUES = "Assignment issues";
    public static final String CONFUSING_CODE_CONSTRUCTS = "Potentially confusing code constructs";
    public static final String CONTROL_FLOW = "Control Flow";
    public static final String PROBABLE_BUGS = "Probable bugs";
    public static final String ERROR_HANDLING = "Error handling";
    public static final String GPATH = "GPath inspections";
    public static final String METHOD_METRICS = "Method Metrics";
    public static final String THREADING_ISSUES = "Threading issues";
    public static final String VALIDITY_ISSUES = "Validity issues";
    public static final String ANNOTATIONS_ISSUES = "Annotations verifying";

    public String[] getGroupPath() {
        return new String[]{"Groovy", this.getGroupDisplayName()};
    }

    public String getShortName() {
        return this.m_shortName;
    }

    protected BaseInspectionVisitor buildGroovyVisitor(ProblemsHolder problemsHolder, boolean onTheFly) {
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(problemsHolder);
        visitor.setOnTheFly(onTheFly);
        visitor.setInspection(this);
        return visitor;
    }

    protected String buildErrorString(Object ... args) {
        return null;
    }

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    protected GroovyFix buildFix(PsiElement location) {
        return null;
    }

    protected GroovyFix[] buildFixes(PsiElement location) {
        return null;
    }

    public ProblemDescriptor[] checkFile(PsiFile psiFile, InspectionManager inspectionManager, boolean isOnTheFly) {
        if (!(psiFile instanceof GroovyFileBase)) {
            return super.checkFile(psiFile, inspectionManager, isOnTheFly);
        }
        GroovyFileBase groovyFile = (GroovyFileBase)psiFile;
        ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, psiFile, isOnTheFly);
        BaseInspectionVisitor visitor = this.buildGroovyVisitor(problemsHolder, isOnTheFly);
        groovyFile.accept(visitor);
        return problemsHolder.getResultsArray();
    }

    protected abstract BaseInspectionVisitor buildVisitor();
}

