/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public abstract class BaseInspectionVisitor
extends GroovyRecursiveElementVisitor {
    private BaseInspection inspection = null;
    private ProblemsHolder problemsHolder = null;
    private boolean onTheFly = false;

    public void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    public void setProblemsHolder(ProblemsHolder problemsHolder) {
        this.problemsHolder = problemsHolder;
    }

    public void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    protected void registerStatementError(GrStatement statement, Object ... args) {
        PsiElement statementToken = statement.getFirstChild();
        this.registerError(statementToken, args);
    }

    protected void registerClassError(GrTypeDefinition aClass, Object ... args) {
        PsiElement statementToken = aClass.getNameIdentifierGroovy();
        this.registerError(statementToken, args);
    }

    protected void registerError(PsiElement location) {
        if (location == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(location));
        this.registerError(location, description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerMethodError(GrMethod method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fixes = this.createFixes(method);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(method.getNameIdentifierGroovy(), description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerVariableError(GrVariable variable, Object ... args) {
        if (variable == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(variable);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(variable.getNameIdentifierGroovy(), description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerMethodCallError(GrMethodCall method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fixes = this.createFixes(method);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        GrExpression invoked = method.getInvokedExpression();
        PsiElement nameElement = ((GrReferenceExpression)invoked).getReferenceNameElement();
        assert (nameElement != null);
        this.registerError(nameElement, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerError(PsiElement location, String description, LocalQuickFix[] fixes, ProblemHighlightType highlightType) {
        this.problemsHolder.registerProblem(location, description, highlightType, fixes);
    }

    protected void registerError(PsiElement location, Object ... args) {
        this.registerError(location, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, args);
    }

    protected void registerError(PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        LocalQuickFix[] fix = this.createFixes(location);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(location, description, fix, highlightType);
    }

    private LocalQuickFix[] createFixes(PsiElement location) {
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        LocalQuickFix[] fixes = this.inspection.buildFixes(location);
        if (fixes != null) {
            return fixes;
        }
        GroovyFix fix = this.inspection.buildFix(location);
        if (fix == null) {
            return null;
        }
        return new GroovyFix[]{fix};
    }

    public int getErrorCount() {
        return this.problemsHolder.getResultCount();
    }
}

