/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public abstract class GroovyLocalInspectionBase
extends GroovySuppressableInspectionTool {
    public String[] getGroupPath() {
        return new String[]{"Groovy", this.getGroupDisplayName()};
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder problemsHolder, boolean isOnTheFly) {
        return new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            @Override
            public void visitClosure(GrClosableBlock closure) {
                GroovyLocalInspectionBase.this.check(closure, problemsHolder);
            }

            @Override
            public void visitMethod(GrMethod method) {
                GrOpenBlock block = method.getBlock();
                if (block != null) {
                    GroovyLocalInspectionBase.this.check(block, problemsHolder);
                }
            }

            @Override
            public void visitFile(GroovyFileBase file) {
                GroovyLocalInspectionBase.this.check(file, problemsHolder);
            }

            @Override
            public void visitClassInitializer(GrClassInitializer initializer) {
                GroovyLocalInspectionBase.this.check(initializer.getBlock(), problemsHolder);
            }
        });
    }

    protected abstract void check(GrControlFlowOwner var1, ProblemsHolder var2);
}

