/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyAssignmentToForLoopParameterInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Assignment issues";
    }

    public String getDisplayName() {
        return "Assignment to for-loop parameter";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Assignment to for-loop parameter '#ref' #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression grAssignmentExpression) {
            super.visitAssignmentExpression(grAssignmentExpression);
            GrExpression lhs = grAssignmentExpression.getLValue();
            if (!(lhs instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)lhs).resolve();
            if (referent == null) {
                return;
            }
            if (!(referent instanceof GrParameter)) {
                return;
            }
            PsiElement parent = referent.getParent();
            if (!(parent instanceof GrForClause)) {
                return;
            }
            if (parent instanceof GrTraditionalForClause && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)grAssignmentExpression, (boolean)true)) {
                return;
            }
            this.registerError(lhs);
        }
    }
}

