/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.bugs.RecursionUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyInfiniteRecursionInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Probable bugs";
    }

    public String getDisplayName() {
        return "Infinite recursion";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "<code>#ref</code> recurses infinitely, and can only complete by throwing an exception #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod method) {
            super.visitMethod(method);
            if (method.hasModifierProperty("abstract")) {
                return;
            }
            if (!RecursionUtils.methodMayRecurse(method)) {
                return;
            }
            if (!RecursionUtils.methodDefinitelyRecurses(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

