/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.HashMap;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class ClashingGettersInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    public String getDisplayName() {
        return "Clashing getters";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyInspectionBundle.message("getter.0.clashes.with.getter.1", args);
    }

    @Override
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
                super.visitTypeDefinition(typeDefinition);
                HashMap<String, PsiMethod> getters = new HashMap<String, PsiMethod>();
                for (PsiMethod method : typeDefinition.getMethods()) {
                    String methodName = method.getName();
                    if (!GroovyPropertyUtils.isSimplePropertyGetter(method)) continue;
                    String propertyName = GroovyPropertyUtils.getPropertyNameByGetterName(methodName, true);
                    PsiMethod otherGetter = (PsiMethod)getters.get(propertyName);
                    if (otherGetter != null && !methodName.equals(otherGetter.getName())) {
                        Pair description = ClashingGettersInspection.getGetterDescription(method);
                        Pair otherDescription = ClashingGettersInspection.getGetterDescription(otherGetter);
                        if (description.first != null) {
                            this.registerError((PsiElement)description.first, description.second, otherDescription.second);
                        }
                        if (otherDescription.first == null) continue;
                        this.registerError((PsiElement)otherDescription.first, otherDescription.second, description.second);
                        continue;
                    }
                    getters.put(propertyName, method);
                }
            }
        };
    }

    private static Pair<PsiElement, String> getGetterDescription(PsiMethod getter) {
        String name = getter.getName();
        if (getter instanceof GrGdkMethod) {
            return new Pair(null, (Object)("GDK method '" + name + "'"));
        }
        if (getter instanceof GrReflectedMethod) {
            getter = ((GrReflectedMethod)getter).getBaseMethod();
            String info = PsiFormatUtil.formatMethod((PsiMethod)getter, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)3);
            return Pair.create((Object)((GrMethod)getter).getNameIdentifierGroovy(), (Object)("method " + info));
        }
        if (getter instanceof GrMethod) {
            return Pair.create((Object)((GrMethod)getter).getNameIdentifierGroovy(), (Object)("getter '" + name + "'"));
        }
        String info = PsiFormatUtil.formatMethod((PsiMethod)getter, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)3);
        return new Pair(null, (Object)("method " + info));
    }
}

