/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;

public class GroovyThrowFromFinallyBlockInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Error handling";
    }

    public String getDisplayName() {
        return "'throw' inside 'finally' block";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "'#ref' inside 'finally' block #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitThrowStatement(GrThrowStatement throwStatement) {
            super.visitThrowStatement(throwStatement);
            if (!ControlFlowUtils.isInFinallyBlock(throwStatement)) {
                return;
            }
            this.registerStatementError(throwStatement, new Object[0]);
        }
    }
}

