/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.LibraryUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMethodParameterCountInspectionBase
extends GroovyMethodMetricInspection {
    public String getDisplayName() {
        return "Method with too many parameters";
    }

    public String getGroupDisplayName() {
        return "Method Metrics";
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Maximum number of parameters:";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' contains too many parameters (" + args[0] + '>' + args[1] + ')';
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            GrParameter[] parameters = grMethod.getParameters();
            int limit = GroovyMethodParameterCountInspectionBase.this.getLimit();
            if (parameters == null || parameters.length <= limit) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(grMethod)) {
                return;
            }
            this.registerMethodError(grMethod, parameters.length, limit);
        }
    }
}

