/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.NegationCountVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMethodWithMoreThanThreeNegationsInspection
extends BaseInspection {
    public String getDisplayName() {
        return "Method with more than three negations";
    }

    public String getGroupDisplayName() {
        return "Method Metrics";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' has too many negations (" + args[0] + " > 3)";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            NegationCountVisitor visitor = new NegationCountVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor);
            int numNegations = visitor.getNegationCount();
            if (numNegations <= 3) {
                return;
            }
            this.registerMethodError(grMethod, numNegations);
        }
    }
}

