/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import javax.swing.JComponent;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.SideEffectChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovyDoubleCheckedLockingInspection
extends BaseInspection {
    public boolean ignoreOnVolatileVariables = false;

    public String getGroupDisplayName() {
        return "Threading issues";
    }

    public String getDisplayName() {
        return "Double-checked locking";
    }

    @Override
    protected String buildErrorString(Object ... infos) {
        return "Double-checked locking #loc";
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore double-checked locking on volatile fields", (InspectionProfileEntry)this, "ignoreOnVolatileVariables");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleCheckedLockingVisitor();
    }

    private class DoubleCheckedLockingVisitor
    extends BaseInspectionVisitor {
        private DoubleCheckedLockingVisitor() {
        }

        @Override
        public void visitIfStatement(GrIfStatement statement) {
            super.visitIfStatement(statement);
            GrExpression outerCondition = statement.getCondition();
            if (outerCondition == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(outerCondition)) {
                return;
            }
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (!((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) instanceof GrSynchronizedStatement)) {
                return;
            }
            GrSynchronizedStatement syncStatement = (GrSynchronizedStatement)thenBranch;
            GrOpenBlock body = syncStatement.getBody();
            if (body == null) {
                return;
            }
            GrStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return;
            }
            if (!(statements[0] instanceof GrIfStatement)) {
                return;
            }
            GrIfStatement innerIf = (GrIfStatement)statements[0];
            GrExpression innerCondition = innerIf.getCondition();
            if (innerCondition == null) {
                return;
            }
            if (!EquivalenceChecker.expressionsAreEquivalent(innerCondition, outerCondition)) {
                return;
            }
            if (GroovyDoubleCheckedLockingInspection.this.ignoreOnVolatileVariables && this.ifStatementAssignsVolatileVariable(innerIf)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private boolean ifStatementAssignsVolatileVariable(GrIfStatement statement) {
            GrStatement innerThen = statement.getThenBranch();
            if (!((innerThen = ControlFlowUtils.stripBraces(innerThen)) instanceof GrAssignmentExpression)) {
                return false;
            }
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)innerThen;
            GrExpression lhs = assignmentExpression.getLValue();
            if (!(lhs instanceof GrReferenceExpression)) {
                return false;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)element;
            return field.hasModifierProperty("volatile");
        }
    }
}

