/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyNestedSynchronizedStatementInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Threading issues";
    }

    public String getDisplayName() {
        return "Nested 'synchronized' statement";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Nested '#ref' statement #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(GrSynchronizedStatement synchronizedStatement) {
            super.visitSynchronizedStatement(synchronizedStatement);
            GrStatement parent = (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)synchronizedStatement, (Class[])new Class[]{GrSynchronizedStatement.class, GrClosableBlock.class});
            if (parent instanceof GrSynchronizedStatement) {
                this.registerStatementError(synchronizedStatement, new Object[0]);
                return;
            }
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)synchronizedStatement, GrMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                this.registerStatementError(synchronizedStatement, new Object[0]);
            }
        }
    }
}

