/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyPublicFieldAccessedInSynchronizedContextInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Threading issues";
    }

    public String getDisplayName() {
        return "Non-private field accessed in synchronized context";
    }

    @Override
    protected String buildErrorString(Object ... infos) {
        return "Non-private field <code>#ref</code> accessed in synchronized context  #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicFieldAccessedInSynchronizedContextVisitor();
    }

    private static class PublicFieldAccessedInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private PublicFieldAccessedInSynchronizedContextVisitor() {
        }

        @Override
        public void visitReferenceExpression(GrReferenceExpression expression) {
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("private") || field.hasModifierProperty("final")) {
                return;
            }
            if (!PublicFieldAccessedInSynchronizedContextVisitor.isInSynchronizedContext(expression)) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass.hasModifierProperty("private")) {
                return;
            }
            this.registerError(expression);
        }

        private static boolean isInSynchronizedContext(PsiElement element) {
            PsiModifierListOwner modifierListOwner;
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrMethod.class, GrSynchronizedStatement.class});
            if (context instanceof GrSynchronizedStatement) {
                return true;
            }
            return context != null && (modifierListOwner = (PsiModifierListOwner)context).hasModifierProperty("synchronized");
        }
    }
}

