/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ParameterCastFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyTypeCheckVisitorHelper {
    private static final Function<PsiType, PsiType> id = Function.ID;

    protected static GrListOrMap getTupleInitializer(GrExpression initializer) {
        if (initializer instanceof GrListOrMap && initializer.getReference() instanceof LiteralConstructorReference && ((LiteralConstructorReference)initializer.getReference()).getConstructedClassType() != null) {
            return (GrListOrMap)initializer;
        }
        return null;
    }

    public static boolean isOnlyOneMapParam(GrExpression[] exprs) {
        if (exprs.length != 1) {
            return false;
        }
        GrExpression e = exprs[0];
        return TypesUtil.isAssignableByMethodCallConversion((PsiType)TypesUtil.createTypeByFQClassName("java.util.Map", e), e.getType(), e);
    }

    public static PsiElement getExpressionPartToHighlight(GrExpression expr) {
        if (expr instanceof GrClosableBlock) {
            PsiElement highlightElement = ((GrClosableBlock)expr).getLBrace();
            assert (highlightElement != null);
            return highlightElement;
        }
        return expr;
    }

    public static boolean checkSimpleArrayAccess(CallInfo<? extends GrIndexProperty> info, PsiType type, PsiType[] types) {
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        return PsiUtil.isLValue(info.getCall()) ? types.length == 2 && TypesUtil.isAssignable((PsiType)PsiType.INT, types[0], info.getCall()) && TypesUtil.isAssignable(((PsiArrayType)type).getComponentType(), types[1], info.getCall()) : types.length == 1 && TypesUtil.isAssignable((PsiType)PsiType.INT, types[0], info.getCall());
    }

    public static boolean typesAreEqual(PsiType expected, PsiType actual, PsiElement context) {
        return TypesUtil.isAssignableByMethodCallConversion(expected, actual, context) && TypesUtil.isAssignableByMethodCallConversion(actual, expected, context);
    }

    public static boolean hasErrorElements(PsiElement e) {
        if (e == null) {
            return false;
        }
        for (PsiElement child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpockTimesOperator(GrBinaryExpression call) {
        PsiClass aClass;
        GrExpression operand;
        return call.getOperationTokenType() == GroovyTokenTypes.mSTAR && PsiUtil.isExpressionStatement(call) && (operand = call.getLeftOperand()) instanceof GrLiteral && TypesUtil.isNumericType(operand.getType()) && InheritanceUtil.isInheritor((PsiClass)(aClass = PsiUtil.getContextClass(call)), (boolean)false, (String)"spock.lang.Specification");
    }

    public static boolean isOperatorWithSimpleTypes(GrBinaryExpression binary, GroovyResolveResult result) {
        if (result.getElement() != null && result.isApplicable()) {
            return false;
        }
        GrExpression left = binary.getLeftOperand();
        GrExpression right = binary.getRightOperand();
        PsiType ltype = left.getType();
        PsiType rtype = right != null ? right.getType() : null;
        return TypesUtil.isNumericType(ltype) && (rtype == null || TypesUtil.isNumericType(rtype));
    }

    public static LocalQuickFix[] genCastFixes(GrSignature signature, PsiType[] argumentTypes, GrArgumentList argumentList) {
        if (argumentList == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        List<GrExpression> args = GroovyTypeCheckVisitorHelper.getExpressionArgumentsOfCall(argumentList);
        if (args == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<Pair<Integer, PsiType>> allErrors = new ArrayList<Pair<Integer, PsiType>>();
        List<GrClosureSignature> signatures = GrClosureSignatureUtil.generateSimpleSignatures(signature);
        for (GrClosureSignature closureSignature : signatures) {
            GrClosureSignatureUtil.MapResultWithError<PsiType> mapResultWithError = GrClosureSignatureUtil.mapSimpleSignatureWithErrors(closureSignature, argumentTypes, id, argumentList, 1);
            if (mapResultWithError == null) continue;
            List<Pair<Integer, PsiType>> errors = mapResultWithError.getErrors();
            for (Pair<Integer, PsiType> error : errors) {
                if ((Integer)error.first == 0 && PsiImplUtil.hasNamedArguments(argumentList)) continue;
                allErrors.add(error);
            }
        }
        ArrayList<ParameterCastFix> fixes = new ArrayList<ParameterCastFix>();
        for (Pair pair : allErrors) {
            fixes.add(new ParameterCastFix((Integer)pair.first, (PsiType)pair.second, args.get((Integer)pair.first)));
        }
        return fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    public static String buildArgTypesList(PsiType[] argTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = argTypes[i]) != null ? argType.getInternalCanonicalText() : "?");
        }
        builder.append(")");
        return builder.toString();
    }

    public static boolean checkCategoryQualifier(GrReferenceExpression place, GrExpression qualifier, PsiMethod gdkMethod, PsiSubstitutor substitutor) {
        PsiClassType categoryType;
        PsiClass categoryAnnotationOwner = GroovyTypeCheckVisitorHelper.inferCategoryAnnotationOwner(place, qualifier);
        if (categoryAnnotationOwner != null && (categoryType = GdkMethodUtil.getCategoryType(categoryAnnotationOwner)) != null) {
            return GdkMethodUtil.isCategoryMethod(gdkMethod, (PsiType)categoryType, qualifier, substitutor);
        }
        return false;
    }

    public static PsiClass inferCategoryAnnotationOwner(GrReferenceExpression place, GrExpression qualifier) {
        PsiElement resolved;
        if (qualifier == null) {
            GrMethod container = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethod.class, (boolean)true, (Class[])new Class[]{GrMember.class});
            if (container != null && !container.hasModifierProperty("static")) {
                return container.getContainingClass();
            }
        } else if (PsiUtil.isThisReference(qualifier) && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
            return (PsiClass)resolved;
        }
        return null;
    }

    public static String getLValueVarName(PsiElement highlight) {
        PsiElement resolved;
        PsiElement parent = highlight.getParent();
        if (parent instanceof GrVariable) {
            return ((GrVariable)parent).getName();
        }
        if (highlight instanceof GrReferenceExpression && parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getLValue() == highlight && (resolved = ((GrReferenceExpression)highlight).resolve()) instanceof GrVariable && PsiUtil.isLocalVariable(resolved)) {
            return ((GrVariable)resolved).getName();
        }
        return null;
    }

    public static List<GrExpression> getExpressionArgumentsOfCall(GrArgumentList argumentList) {
        ArrayList args = ContainerUtil.newArrayList();
        for (GroovyPsiElement arg : argumentList.getAllArguments()) {
            if (arg instanceof GrSpreadArgument) {
                GrExpression spreaded = ((GrSpreadArgument)arg).getArgument();
                if (spreaded instanceof GrListOrMap && !((GrListOrMap)spreaded).isMap()) {
                    Collections.addAll(args, ((GrListOrMap)spreaded).getInitializers());
                    continue;
                }
                return null;
            }
            if (arg instanceof GrExpression) {
                args.add((GrExpression)arg);
                continue;
            }
            if (!(arg instanceof GrNamedArgument)) continue;
            args.add(((GrNamedArgument)arg).getExpression());
        }
        PsiElement parent = argumentList.getParent();
        if (parent instanceof GrIndexProperty && PsiUtil.isLValue((GroovyPsiElement)parent)) {
            args.add(TypeInferenceHelper.getInitializerFor((GrExpression)parent));
        } else if (parent instanceof GrMethodCallExpression) {
            ContainerUtil.addAll((Collection)args, (Object[])((GrMethodCallExpression)parent).getClosureArguments());
        }
        return args;
    }

    static boolean isImplicitReturnStatement(GrExpression expression) {
        GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(expression);
        return flowOwner != null && PsiUtil.isExpressionStatement(expression) && ControlFlowUtils.isReturnValue(expression, flowOwner) && !PsiUtil.isVoidMethodCall(expression);
    }
}

