/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.util.IncorrectOperationException;
import java.util.Comparator;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.editor.GroovyImportOptimizer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GroovyCodeStyleManagerImpl
extends GroovyCodeStyleManager {
    @Override
    public GrImportStatement addImport(GroovyFile psiFile, GrImportStatement statement) throws IncorrectOperationException {
        PsiElement anchor = this.getAnchorToInsertImportAfter(psiFile, statement);
        PsiElement result = psiFile.addAfter(statement, anchor);
        GrImportStatement gImport = (GrImportStatement)result;
        this.addLineFeedBefore(psiFile, gImport);
        this.addLineFeedAfter(psiFile, gImport);
        return gImport;
    }

    private PsiElement getShellComment(PsiElement psiFile) {
        ASTNode node = psiFile.getNode().findChildByType(GroovyTokenTypes.mSH_COMMENT);
        return node == null ? null : node.getPsi();
    }

    private PsiElement getAnchorToInsertImportAfter(GroovyFile psiFile, GrImportStatement statement) {
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)psiFile.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class);
        PackageEntryTable layoutTable = settings.IMPORT_LAYOUT_TABLE;
        PackageEntry[] entries = layoutTable.getEntries();
        GrImportStatement[] importStatements = psiFile.getImportStatements();
        if (importStatements.length == 0) {
            GrPackageDefinition definition = psiFile.getPackageDefinition();
            if (definition != null) {
                return definition;
            }
            return this.getShellComment(psiFile);
        }
        Comparator<GrImportStatement> comparator = GroovyImportOptimizer.getComparator(settings);
        int idx = GroovyCodeStyleManagerImpl.getPackageEntryIdx(entries, statement);
        GrTopStatement anchor = null;
        for (GrImportStatement importStatement : importStatements) {
            int i = GroovyCodeStyleManagerImpl.getPackageEntryIdx(entries, importStatement);
            if (i < idx) {
                anchor = importStatement;
                continue;
            }
            if (i > idx || comparator.compare(statement, importStatement) <= 0) break;
            anchor = importStatement;
        }
        if (anchor == null) {
            anchor = psiFile.getPackageDefinition();
        }
        if (anchor == null) {
            anchor = this.getShellComment(psiFile);
        }
        if (anchor == null && importStatements.length > 0) {
            anchor = importStatements[0].getPrevSibling();
        }
        return anchor;
    }

    protected static int getPackageEntryIdx(PackageEntry[] entries, GrImportStatement statement) {
        GrCodeReferenceElement reference = statement.getImportReference();
        if (reference == null) {
            return -1;
        }
        String packageName = StringUtil.getPackageName((String)reference.getCanonicalText());
        boolean isStatic = statement.isStatic();
        int best = -1;
        int allOtherStatic = -1;
        int allOther = -1;
        PackageEntry bestEntry = null;
        int length = entries.length;
        for (int i = 0; i < length; ++i) {
            PackageEntry entry = entries[i];
            if (entry.isBetterMatchForPackageThan(bestEntry, packageName, isStatic)) {
                best = i;
                bestEntry = entry;
                continue;
            }
            if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                allOtherStatic = i;
                continue;
            }
            if (entry != PackageEntry.ALL_OTHER_IMPORTS_ENTRY) continue;
            allOther = i;
        }
        if (best >= 0) {
            return best;
        }
        if (isStatic && allOtherStatic != -1) {
            return allOtherStatic;
        }
        return allOther;
    }

    protected void addLineFeedBefore(PsiElement psiFile, GrImportStatement result) {
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)psiFile.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class);
        PackageEntryTable layoutTable = settings.IMPORT_LAYOUT_TABLE;
        PackageEntry[] entries = layoutTable.getEntries();
        PsiElement prev = result.getPrevSibling();
        while (PsiImplUtil.isWhiteSpaceOrNls(prev)) {
            prev = prev.getPrevSibling();
        }
        if (PsiImplUtil.hasElementType(prev, GroovyTokenTypes.mSEMI)) {
            prev = prev.getPrevSibling();
        }
        if (PsiImplUtil.isWhiteSpaceOrNls(prev)) {
            prev = prev.getPrevSibling();
        }
        if (prev instanceof GrImportStatement) {
            int idx_before = GroovyCodeStyleManagerImpl.getPackageEntryIdx(entries, (GrImportStatement)prev);
            int idx = GroovyCodeStyleManagerImpl.getPackageEntryIdx(entries, result);
            int spaceCount = GroovyCodeStyleManagerImpl.getMaxSpaceCount(entries, idx_before, idx);
            if (PsiImplUtil.isWhiteSpaceOrNls(prev.getNextSibling()) && PsiImplUtil.hasElementType(prev.getNextSibling().getNextSibling(), GroovyTokenTypes.mSEMI)) {
                prev = prev.getNextSibling().getNextSibling();
            }
            ASTNode node = psiFile.getNode();
            while (PsiImplUtil.isWhiteSpaceOrNls(prev.getNextSibling())) {
                node.removeChild(prev.getNextSibling().getNode());
            }
            node.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)StringUtil.repeat((String)"\n", (int)(spaceCount + 1)), result.getNode());
        }
    }

    protected void addLineFeedAfter(PsiElement psiFile, GrImportStatement result) {
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)psiFile.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class);
        PackageEntryTable layoutTable = settings.IMPORT_LAYOUT_TABLE;
        PackageEntry[] entries = layoutTable.getEntries();
        PsiElement next = result.getNextSibling();
        if (PsiImplUtil.isWhiteSpaceOrNls(next)) {
            next = next.getNextSibling();
        }
        if (PsiImplUtil.hasElementType(next, GroovyTokenTypes.mSEMI)) {
            next = next.getNextSibling();
        }
        while (PsiImplUtil.isWhiteSpaceOrNls(next)) {
            next = next.getNextSibling();
        }
        if (next instanceof GrImportStatement) {
            int idx_after = GroovyCodeStyleManagerImpl.getPackageEntryIdx(entries, (GrImportStatement)next);
            int idx = GroovyCodeStyleManagerImpl.getPackageEntryIdx(entries, result);
            int spaceCount = GroovyCodeStyleManagerImpl.getMaxSpaceCount(entries, idx, idx_after);
            ASTNode node = psiFile.getNode();
            while (PsiImplUtil.isWhiteSpaceOrNls(next.getPrevSibling())) {
                node.removeChild(next.getPrevSibling().getNode());
            }
            node.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)StringUtil.repeat((String)"\n", (int)(spaceCount + 1)), next.getNode());
        }
    }

    private static int getMaxSpaceCount(PackageEntry[] entries, int b1, int b2) {
        int start = Math.min(b1, b2);
        int end = Math.max(b1, b2);
        if (start == -1) {
            return 0;
        }
        int max = 0;
        int cur = 0;
        for (int i = start; i < end; ++i) {
            if (entries[i] == PackageEntry.BLANK_LINE_ENTRY) {
                ++cur;
                continue;
            }
            max = Math.max(max, cur);
            cur = 0;
        }
        max = Math.max(max, cur);
        return max;
    }

    @Override
    public void removeImport(GroovyFileBase psiFile, GrImportStatement importStatement) throws IncorrectOperationException {
        GrImportStatement after;
        GroovyFileBase psiElement = psiFile;
        GrImportStatement before = importStatement;
        while (PsiImplUtil.isWhiteSpaceOrNls(before.getPrevSibling())) {
            before = before.getPrevSibling();
        }
        if (PsiImplUtil.hasElementType(before.getPrevSibling(), GroovyTokenTypes.mSEMI)) {
            before = before.getPrevSibling();
        }
        if (PsiImplUtil.isWhiteSpaceOrNls(before.getPrevSibling())) {
            before = before.getPrevSibling();
        }
        if (PsiImplUtil.isWhiteSpaceOrNls((after = importStatement).getNextSibling())) {
            after = after.getNextSibling();
        }
        if (PsiImplUtil.hasElementType(after.getNextSibling(), GroovyTokenTypes.mSEMI)) {
            after = after.getNextSibling();
        }
        while (PsiImplUtil.isWhiteSpaceOrNls(after.getNextSibling())) {
            after = after.getNextSibling();
        }
        if (before == null) {
            before = importStatement;
        }
        PsiElement anchor_before = before.getPrevSibling();
        PsiElement anchor_after = after.getNextSibling();
        if (before == after) {
            importStatement.delete();
        } else {
            psiFile.deleteChildRange(before, after);
        }
        if (anchor_before instanceof GrImportStatement && anchor_after instanceof GrImportStatement) {
            this.addLineFeedAfter(psiFile, (GrImportStatement)anchor_before);
        } else if (anchor_before != null && anchor_after != null) {
            String text = anchor_after instanceof GrTopStatement && anchor_before instanceof GrTopStatement ? "\n\n" : "\n";
            psiElement.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)text, anchor_after.getNode());
        }
    }
}

