/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class AbstractConfigUtils {
    @NonNls
    protected String STARTER_SCRIPT_FILE_NAME;
    private final Condition<Library> LIB_SEARCH_CONDITION = new Condition<Library>(){

        public boolean value(Library library) {
            return AbstractConfigUtils.this.isSDKLibrary(library);
        }
    };
    @NonNls
    public static final String UNDEFINED_VERSION = "undefined";
    @NonNls
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    public abstract boolean isSDKHome(VirtualFile var1);

    public abstract String getSDKVersion(String var1);

    public static String getSDKJarVersion(String jarPath, String jarRegex, String manifestPath) {
        return AbstractConfigUtils.getSDKJarVersion(jarPath, Pattern.compile(jarRegex), manifestPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSDKJarVersion(String jarPath, Pattern jarPattern, String manifestPath) {
        try {
            File[] jars = LibrariesUtil.getFilesInDirectoryByPattern(jarPath, jarPattern);
            if (jars.length != 1) {
                return null;
            }
            JarFile jarFile = new JarFile(jars[0]);
            try {
                Manifest manifest;
                JarEntry jarEntry = jarFile.getJarEntry(manifestPath);
                if (jarEntry == null) {
                    String string = null;
                    return string;
                }
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                try {
                    manifest = new Manifest(inputStream);
                }
                finally {
                    inputStream.close();
                }
                String version = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                if (version != null) {
                    String string = version;
                    return string;
                }
                Matcher matcher = jarPattern.matcher(jars[0].getName());
                if (matcher.matches() && matcher.groupCount() == 1) {
                    String string = matcher.group(1);
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                jarFile.close();
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public Library[] getProjectSDKLibraries(Project project) {
        if (project == null || project.isDisposed()) {
            return new Library[0];
        }
        LibraryTable table = ProjectLibraryTable.getInstance((Project)project);
        List all = ContainerUtil.findAll((Object[])table.getLibraries(), this.LIB_SEARCH_CONDITION);
        return all.toArray(new Library[all.size()]);
    }

    public Library[] getAllSDKLibraries(Project project) {
        return (Library[])ArrayUtil.mergeArrays((Object[])this.getGlobalSDKLibraries(), (Object[])this.getProjectSDKLibraries(project));
    }

    public Library[] getAllUsedSDKLibraries(Project project) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            libraries.addAll(Arrays.asList(this.getSDKLibrariesByModule(module)));
        }
        return libraries.toArray(new Library[libraries.size()]);
    }

    public Library[] getGlobalSDKLibraries() {
        return LibrariesUtil.getGlobalLibraries(this.LIB_SEARCH_CONDITION);
    }

    public abstract boolean isSDKLibrary(Library var1);

    public Library[] getSDKLibrariesByModule(Module module) {
        Condition<Library> condition = new Condition<Library>(){

            public boolean value(Library library) {
                return AbstractConfigUtils.this.isSDKLibrary(library);
            }
        };
        return LibrariesUtil.getLibrariesByCondition(module, condition);
    }
}

