/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GroovyLibraryDescription
extends CustomLibraryDescription {
    private static final String GROOVY_FRAMEWORK_NAME = "Groovy";
    private final String myEnvVariable;
    private final Set<? extends LibraryKind> myLibraryKinds;
    private final String myFrameworkName;

    public GroovyLibraryDescription() {
        this("GROOVY_HOME", GroovyLibraryDescription.getAllGroovyKinds(), GROOVY_FRAMEWORK_NAME);
    }

    public static Set<? extends LibraryKind> getAllGroovyKinds() {
        HashSet<LibraryKind> kinds = new HashSet<LibraryKind>();
        for (LibraryPresentationProvider provider : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
            if (!(provider instanceof GroovyLibraryPresentationProviderBase)) continue;
            kinds.add(provider.getKind());
        }
        return kinds;
    }

    public GroovyLibraryDescription(String envVariable, LibraryKind libraryKind, String frameworkName) {
        this(envVariable, Collections.singleton(libraryKind), frameworkName);
    }

    private GroovyLibraryDescription(String envVariable, Set<? extends LibraryKind> libraryKinds, String frameworkName) {
        this.myEnvVariable = envVariable;
        this.myLibraryKinds = libraryKinds;
        this.myFrameworkName = frameworkName;
    }

    public static GroovyLibraryPresentationProviderBase findManager(VirtualFile dir) {
        String name = dir.getName();
        List providers = ContainerUtil.findAll((Object[])LibraryPresentationProvider.EP_NAME.getExtensions(), GroovyLibraryPresentationProviderBase.class);
        for (GroovyLibraryPresentationProviderBase provider : providers) {
            if (!provider.managesName(name) || !provider.isSDKHome(dir)) continue;
            return provider;
        }
        for (GroovyLibraryPresentationProviderBase manager : providers) {
            if (!manager.isSDKHome(dir)) continue;
            return manager;
        }
        return null;
    }

    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        return this.myLibraryKinds;
    }

    public NewLibraryConfiguration createNewLibrary(JComponent parentComponent, VirtualFile contextDirectory) {
        VirtualFile initial = GroovyLibraryDescription.findFile(System.getenv(this.myEnvVariable));
        if (initial == null && GROOVY_FRAMEWORK_NAME.equals(this.myFrameworkName) && SystemInfo.isLinux) {
            initial = GroovyLibraryDescription.findFile("/usr/share/groovy");
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                if (!super.isFileSelectable(file)) {
                    return false;
                }
                return GroovyLibraryDescription.findManager(file) != null;
            }
        };
        descriptor.setTitle(this.myFrameworkName + " SDK");
        descriptor.setDescription("Choose a directory containing " + this.myFrameworkName + " distribution");
        VirtualFile dir = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)parentComponent, null, (VirtualFile)initial);
        if (dir == null) {
            return null;
        }
        final GroovyLibraryPresentationProviderBase provider = GroovyLibraryDescription.findManager(dir);
        if (provider == null) {
            return null;
        }
        final String path = dir.getPath();
        String sdkVersion = provider.getSDKVersion(path);
        if ("undefined".equals(sdkVersion)) {
            Messages.showErrorDialog((Component)parentComponent, (String)("Looks like " + this.myFrameworkName + " distribution in specified path is broken. Cannot determine version."), (String)"Failed to Create Library");
            return null;
        }
        return new NewLibraryConfiguration(provider.getLibraryPrefix() + "-" + sdkVersion){

            public void addRoots(LibraryEditor editor) {
                provider.fillLibrary(path, editor);
            }
        };
    }

    private static VirtualFile findFile(String path) {
        if (path != null && !path.isEmpty()) {
            return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
        }
        return null;
    }

    public LibrariesContainer.LibraryLevel getDefaultLevel() {
        return LibrariesContainer.LibraryLevel.GLOBAL;
    }
}

