/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.config.GroovyLibraryProperties;

public abstract class GroovyLibraryPresentationProviderBase
extends LibraryPresentationProvider<GroovyLibraryProperties> {
    public GroovyLibraryPresentationProviderBase(LibraryKind kind) {
        super(kind);
    }

    public String getDescription(GroovyLibraryProperties properties) {
        String version = properties.getVersion();
        return this.getLibraryCategoryName() + " library" + (version != null ? " of version " + version : ":");
    }

    public GroovyLibraryProperties detect(List<VirtualFile> classesRoots) {
        VirtualFile[] libraryFiles = VfsUtilCore.toVirtualFileArray(classesRoots);
        if (this.managesLibrary(libraryFiles)) {
            String version = this.getLibraryVersion(libraryFiles);
            return new GroovyLibraryProperties(version);
        }
        return null;
    }

    protected abstract void fillLibrary(String var1, LibraryEditor var2);

    public abstract boolean managesLibrary(VirtualFile[] var1);

    public abstract String getLibraryVersion(VirtualFile[] var1);

    public abstract Icon getIcon();

    public abstract boolean isSDKHome(VirtualFile var1);

    public abstract String getSDKVersion(String var1);

    public abstract String getLibraryCategoryName();

    public String getLibraryPrefix() {
        return StringUtil.toLowerCase((String)this.getLibraryCategoryName());
    }

    public boolean managesName(String name) {
        return StringUtil.startsWithIgnoreCase((String)name, (String)this.getLibraryPrefix());
    }
}

