/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathsList;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.console.GroovyShellRunner;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyConsoleRunner
extends GroovyShellRunner {
    @Override
    public String getWorkingDirectory(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return contentRoots[0].getPath();
    }

    @Override
    public JavaParameters createJavaParameters(Module module) throws ExecutionException {
        JavaParameters res = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(res, module, "groovy.ui.GroovyMain", !GroovyConsoleRunner.hasGroovyAll(module), true);
        PathsList list = GroovyScriptRunner.getClassPathFromRootModel(module, true, res, true, res.getClassPath());
        if (list != null) {
            res.getClassPath().addAll(list.getPathList());
        }
        res.getProgramParametersList().addAll(new String[]{"-p", GroovyScriptRunner.getPathInConf("console.txt")});
        res.setWorkingDirectory(this.getWorkingDirectory(module));
        return res;
    }

    @Override
    public boolean canRun(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return contentRoots.length > 0;
    }

    @Override
    public String getTitle(Module module) {
        String moduleGroovyHomePath = LibrariesUtil.getGroovyHomePath(module);
        boolean bundled = moduleGroovyHomePath == null || !GroovyConsoleRunner.hasGroovyAll(module);
        String homePathToUse = bundled ? GroovyFacetUtil.getBundledGroovyJar().getParentFile().getParent() : moduleGroovyHomePath;
        String version = GroovyConfigUtils.getInstance().getSDKVersion(homePathToUse);
        return version == "undefined" ? "" : " (" + (bundled ? "Bundled " : "") + "Groovy " + version + ")";
    }

    private static boolean hasGroovyAll(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return (facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null) && facade.findClass("groovy.ui.GroovyMain", scope) != null;
    }

    @Override
    public String transformUserInput(String userInput) {
        return StringUtil.replace((String)userInput, (String)"\n", (String)"###\\n");
    }
}

