/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.plugins.groovy.dgm.DGMUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;

public class DGMCompletionContributor
extends CompletionContributor {
    public DGMCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PropertiesTokenTypes.KEY_CHARACTERS), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                PsiElement position = parameters.getPosition();
                if (!DGMUtil.isInDGMFile(position)) {
                    return;
                }
                Map map = ((PropertiesFile)position.getContainingFile()).getNamesMap();
                for (String key : DGMUtil.KEYS) {
                    if (map.containsKey(key)) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)key));
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PropertiesTokenTypes.VALUE_CHARACTERS), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, final CompletionResultSet result) {
                PsiElement position = parameters.getPosition();
                if (!DGMUtil.isInDGMFile(position)) {
                    return;
                }
                AllClassesGetter.processJavaClasses((CompletionParameters)parameters, (PrefixMatcher)result.getPrefixMatcher(), (boolean)true, (Consumer)new Consumer<PsiClass>(){

                    public void consume(PsiClass aClass) {
                        result.addElement(GroovyCompletionUtil.createClassLookupItem(aClass));
                    }
                });
            }
        });
    }
}

