/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.codeInsight.editorActions.CopyPasteReferenceProcessor;
import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyReferenceCopyPasteProcessor
extends CopyPasteReferenceProcessor<GrReferenceElement> {
    private static final Logger LOG = Logger.getInstance(GroovyReferenceCopyPasteProcessor.class);

    protected void addReferenceData(PsiFile file, int startOffset, PsiElement element, ArrayList<ReferenceData> to) {
        GroovyResolveResult resolveResult;
        PsiElement refElement;
        if (element instanceof GrReferenceElement && ((GrReferenceElement)element).getQualifier() == null && (refElement = (resolveResult = ((GrReferenceElement)element).advancedResolve()).getElement()) != null) {
            if (refElement instanceof PsiClass) {
                String qName;
                if (refElement.getContainingFile() != element.getContainingFile() && (qName = ((PsiClass)refElement).getQualifiedName()) != null) {
                    GroovyReferenceCopyPasteProcessor.addReferenceData((PsiElement)element, to, (int)startOffset, (String)qName, null);
                }
            } else if (resolveResult.getCurrentFileResolveContext() instanceof GrImportStatement && ((GrImportStatement)resolveResult.getCurrentFileResolveContext()).isStatic()) {
                String classQName = ((PsiMember)refElement).getContainingClass().getQualifiedName();
                String name = ((PsiNamedElement)refElement).getName();
                if (classQName != null && name != null) {
                    GroovyReferenceCopyPasteProcessor.addReferenceData((PsiElement)element, to, (int)startOffset, (String)classQName, (String)name);
                }
            }
        }
    }

    protected GrReferenceElement[] findReferencesToRestore(PsiFile file, RangeMarker bounds, ReferenceData[] referenceData) {
        PsiManager manager = file.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiResolveHelper helper = facade.getResolveHelper();
        GrReferenceElement[] refs = new GrReferenceElement[referenceData.length];
        for (int i = 0; i < referenceData.length; ++i) {
            PsiElement referent;
            GrReferenceElement reference;
            TextRange range;
            ReferenceData data = referenceData[i];
            PsiClass refClass = facade.findClass(data.qClassName, file.getResolveScope());
            if (refClass == null) continue;
            int startOffset = data.startOffset + bounds.getStartOffset();
            int endOffset = data.endOffset + bounds.getStartOffset();
            PsiElement element = file.findElementAt(startOffset);
            if (element == null || !(element.getParent() instanceof GrReferenceElement) || PsiUtil.isThisOrSuperRef(element.getParent()) || (range = (reference = (GrReferenceElement)element.getParent()).getTextRange()).getStartOffset() != startOffset || range.getEndOffset() != endOffset) continue;
            if (data.staticMemberName == null) {
                PsiClass refClass1 = helper.resolveReferencedClass(reference.getText(), (PsiElement)reference);
                if (refClass1 != null && manager.areElementsEquivalent((PsiElement)refClass, (PsiElement)refClass1)) continue;
                refs[i] = reference;
                continue;
            }
            if (!(reference instanceof GrReferenceExpression) || (referent = this.resolveReferenceIgnoreOverriding(reference)) instanceof PsiNamedElement && data.staticMemberName.equals(((PsiNamedElement)referent).getName()) && referent instanceof PsiMember && ((PsiMember)referent).getContainingClass() != null && data.qClassName.equals(((PsiMember)referent).getContainingClass().getQualifiedName())) continue;
            refs[i] = reference;
        }
        return refs;
    }

    protected void restoreReferences(ReferenceData[] referenceData, GrReferenceElement[] refs) {
        for (int i = 0; i < refs.length; ++i) {
            GrReferenceElement reference = refs[i];
            if (reference == null) continue;
            try {
                PsiManager manager = reference.getManager();
                ReferenceData refData = referenceData[i];
                PsiClass refClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(refData.qClassName, reference.getResolveScope());
                if (refClass == null) continue;
                if (refData.staticMemberName == null) {
                    reference.bindToElement((PsiElement)refClass);
                    continue;
                }
                LOG.assertTrue(reference instanceof GrReferenceExpression);
                PsiMember member = GroovyReferenceCopyPasteProcessor.findMember(refData, refClass);
                if (member == null) continue;
                ((GrReferenceExpression)reference).bindToElementViaStaticImport(member);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static PsiMember findMember(ReferenceData refData, PsiClass refClass) {
        PsiField field = refClass.findFieldByName(refData.staticMemberName, true);
        if (field != null) {
            return field;
        }
        PsiMethod[] methods = refClass.findMethodsByName(refData.staticMemberName, true);
        if (methods.length != 0) {
            return methods[0];
        }
        return null;
    }
}

