/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.JavaTypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyTypedHandler
extends TypedHandlerDelegate {
    static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSEMI, GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mRCURLY});
    private boolean myJavaLTTyped;

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, final Editor editor, PsiFile file, FileType fileType) {
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && file instanceof GroovyFile && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && GroovyTypedHandler.isAfterClassLikeIdentifier(offsetBefore, editor);
        if ('>' == c && file instanceof GroovyFile && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JavaTypedHandler.handleJavaGT((Editor)editor, (IElementType)GroovyTokenTypes.mLT, (IElementType)GroovyTokenTypes.mGT, (TokenSet)INVALID_INSIDE_REFERENCE)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == '@' && file instanceof GroovyFile) {
            GroovyTypedHandler.autoPopupMemberLookup(project, editor, new Condition<PsiFile>(){

                public boolean value(PsiFile file) {
                    int offset = editor.getCaretModel().getOffset();
                    PsiElement lastElement = file.findElementAt(offset - 1);
                    if (lastElement == null) {
                        return false;
                    }
                    PsiElement prevSibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastElement);
                    return prevSibling != null && ".".equals(prevSibling.getText());
                }
            });
        }
        if (c == '&' && file instanceof GroovyFile) {
            GroovyTypedHandler.autoPopupMemberLookup(project, editor, new Condition<PsiFile>(){

                public boolean value(PsiFile file) {
                    int offset = editor.getCaretModel().getOffset();
                    PsiElement lastElement = file.findElementAt(offset - 1);
                    return lastElement != null && ".&".equals(lastElement.getText());
                }
            });
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static void autoPopupMemberLookup(Project project, Editor editor, Condition<PsiFile> condition) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, condition);
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, Editor editor, PsiFile file) {
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            JavaTypedHandler.handleAfterJavaLT((Editor)editor, (IElementType)GroovyTokenTypes.mLT, (IElementType)GroovyTokenTypes.mGT, (TokenSet)INVALID_INSIDE_REFERENCE);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public static boolean isAfterClassLikeIdentifier(int offset, Editor editor) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
        }
        return JavaTypedHandler.isClassLikeIdentifier((int)offset, (Editor)editor, (HighlighterIterator)iterator, (IElementType)GroovyTokenTypes.mIDENT);
    }
}

