/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GeeseUtil {
    private static final Logger LOG = Logger.getInstance(GeeseUtil.class);

    private GeeseUtil() {
    }

    public static ASTNode getClosureRBraceAtTheEnd(ASTNode node) {
        ASTNode lastChild;
        IElementType elementType = node.getElementType();
        if (elementType == GroovyElementTypes.CLOSABLE_BLOCK) {
            PsiElement rBrace = ((GrClosableBlock)node.getPsi()).getRBrace();
            return rBrace != null ? rBrace.getNode() : null;
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && PsiImplUtil.isWhiteSpaceOrNls(lastChild); lastChild = lastChild.getTreePrev()) {
        }
        if (lastChild == null) {
            return null;
        }
        return GeeseUtil.getClosureRBraceAtTheEnd(lastChild);
    }

    public static boolean isClosureRBrace(PsiElement e) {
        return e != null && e.getNode().getElementType() == GroovyTokenTypes.mRCURLY && e.getParent() instanceof GrClosableBlock && ((GrClosableBlock)e.getParent()).getRBrace() == e;
    }

    public static PsiElement getNextNonWhitespaceToken(PsiElement e) {
        PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)e);
        while (next != null && next.getNode().getElementType() == TokenType.WHITE_SPACE) {
            next = PsiTreeUtil.nextLeaf((PsiElement)next);
        }
        return next;
    }

    static void calculateRBraceAlignment(PsiElement rBrace, AlignmentProvider alignments) {
        PsiElement p;
        int leadingBraceCount = 0;
        if (!GeeseUtil.isClosureContainLF(rBrace)) {
            return;
        }
        PsiElement next = PsiUtil.getPreviousNonWhitespaceToken(rBrace);
        while (GeeseUtil.isClosureRBrace(next) && GeeseUtil.isClosureContainLF(next)) {
            ++leadingBraceCount;
            next = PsiUtil.getPreviousNonWhitespaceToken(next);
        }
        Object cur = rBrace;
        next = GeeseUtil.getNextNonWhitespaceToken(cur);
        while (GeeseUtil.isClosureRBrace(next)) {
            cur = next;
            next = GeeseUtil.getNextNonWhitespaceToken(cur);
        }
        while (leadingBraceCount > 0) {
            cur = PsiUtil.getPreviousNonWhitespaceToken(cur);
            --leadingBraceCount;
        }
        PsiElement parent = cur.getParent();
        LOG.assertTrue(parent instanceof GrClosableBlock);
        cur = parent;
        if (cur.getParent() instanceof GrMethodCall) {
            GrMethodCall call = (GrMethodCall)cur.getParent();
            GrExpression invoked = call.getInvokedExpression();
            cur = invoked instanceof GrReferenceExpression && ((GrReferenceExpression)invoked).getReferenceNameElement() != null ? ((GrReferenceExpression)invoked).getReferenceNameElement() : call;
        }
        cur = PsiTreeUtil.getDeepestFirst((PsiElement)cur);
        while (!(PsiUtil.isNewLine(next = PsiTreeUtil.prevLeaf((PsiElement)cur, (boolean)true)) || next == null || next.getNode().getElementType() == TokenType.WHITE_SPACE && PsiTreeUtil.prevLeaf((PsiElement)next) == null)) {
            cur = next;
        }
        int startOffset = cur.getTextRange().getStartOffset();
        int endOffset = rBrace.getTextRange().getStartOffset();
        if (rBrace.getContainingFile().getText().substring(startOffset, endOffset).indexOf(10) < 0) {
            return;
        }
        while ((p = cur.getParent()) != null && p.getTextOffset() == cur.getTextOffset()) {
            cur = p;
        }
        alignments.addPair(rBrace, (PsiElement)cur, (Boolean)true);
    }

    public static boolean isClosureContainLF(PsiElement rBrace) {
        PsiElement parent = rBrace.getParent();
        return parent.getText().indexOf(10) >= 0;
    }
}

