/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;

public class ClosureBodyBlock
extends GroovyBlock {
    private TextRange myTextRange;

    public ClosureBodyBlock(ASTNode node, Indent indent, Wrap wrap, FormattingContext context) {
        super(node, indent, wrap, context);
    }

    @Override
    public TextRange getTextRange() {
        this.init();
        return this.myTextRange;
    }

    private void init() {
        if (this.mySubBlocks == null) {
            GroovyBlockGenerator generator = new GroovyBlockGenerator(this);
            List<ASTNode> children = GroovyBlockGenerator.getClosureBodyVisibleChildren(this.myNode.getTreeParent());
            this.mySubBlocks = generator.generateSubBlockForCodeBlocks(false, children, this.myContext.getGroovySettings().INDENT_LABEL_BLOCKS);
            assert (!this.mySubBlocks.isEmpty());
            TextRange firstRange = ((Block)this.mySubBlocks.get(0)).getTextRange();
            TextRange lastRange = ((Block)this.mySubBlocks.get(this.mySubBlocks.size() - 1)).getTextRange();
            this.myTextRange = new TextRange(firstRange.getStartOffset(), lastRange.getEndOffset());
        }
    }

    @Override
    public List<Block> getSubBlocks() {
        this.init();
        return this.mySubBlocks;
    }

    @Override
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(Indent.getNormalIndent(), null);
    }

    @Override
    public boolean isIncomplete() {
        return true;
    }
}

