/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.ClosureBodyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GrLabelBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockWithRange;
import org.jetbrains.plugins.groovy.formatter.blocks.MethodCallWithoutQualifierBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.ParameterListBlock;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyIndentProcessor;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyWrappingProcessor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParserDefinition;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyBlockGenerator {
    private static final TokenSet NESTED = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.REFERENCE_EXPRESSION, GroovyElementTypes.PATH_INDEX_PROPERTY, GroovyElementTypes.PATH_METHOD_CALL, GroovyElementTypes.PATH_PROPERTY_REFERENCE});
    private static final Logger LOG = Logger.getInstance(GroovyBlockGenerator.class);
    private final GroovyBlock myBlock;
    private final ASTNode myNode;
    private final AlignmentProvider myAlignmentProvider;
    private final GroovyWrappingProcessor myWrappingProcessor;
    private final FormattingContext myContext;

    public GroovyBlockGenerator(GroovyBlock block) {
        this.myBlock = block;
        this.myNode = this.myBlock.getNode();
        this.myContext = block.getContext();
        this.myAlignmentProvider = this.myContext.getAlignmentProvider();
        this.myWrappingProcessor = new GroovyWrappingProcessor(this.myBlock);
    }

    static List<ASTNode> getClosureBodyVisibleChildren(ASTNode node) {
        ASTNode last;
        ASTNode first;
        List<ASTNode> children = GroovyBlockGenerator.visibleChildren(node);
        if (!children.isEmpty() && (first = children.get(0)).getElementType() == GroovyTokenTypes.mLCURLY) {
            children.remove(0);
        }
        if (!children.isEmpty() && (last = children.get(children.size() - 1)).getElementType() == GroovyTokenTypes.mRCURLY) {
            children.remove(children.size() - 1);
        }
        return children;
    }

    public List<Block> generateSubBlocks() {
        ArrayList<Block> subBlocks;
        ArrayList<Block> subBlocks2;
        String text;
        PsiElement blockPsi = this.myNode.getPsi();
        IElementType elementType = this.myNode.getElementType();
        if (blockPsi instanceof GrBinaryExpression && !(blockPsi.getParent() instanceof GrBinaryExpression)) {
            return this.generateForBinaryExpr();
        }
        if ((elementType == GroovyTokenTypes.mSTRING_LITERAL || elementType == GroovyTokenTypes.mGSTRING_LITERAL) && this.myBlock.getTextRange().equals((Object)this.myNode.getTextRange()) && (text = this.myNode.getText()).length() > 6 && (text.substring(0, 3).equals("'''") && text.substring(text.length() - 3).equals("'''") || text.substring(0, 3).equals("\"\"\"") & text.substring(text.length() - 3).equals("\"\"\""))) {
            return this.generateForMultiLineString();
        }
        if (elementType == GroovyElementTypes.GSTRING || elementType == GroovyElementTypes.REGEX || elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            ASTNode[] children;
            FormattingContext context = this.myNode.getPsi() instanceof GrString && ((GrString)this.myNode.getPsi()).isPlainString() ? this.myContext.createContext(true) : this.myContext;
            ArrayList<Block> subBlocks3 = new ArrayList<Block>();
            for (ASTNode childNode : children = GroovyBlockGenerator.getGroovyChildren(this.myNode)) {
                if (childNode.getTextRange().getLength() <= 0) continue;
                subBlocks3.add(new GroovyBlock(childNode, this.getIndent(childNode), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), context));
            }
            return subBlocks3;
        }
        if (NESTED.contains(elementType) && blockPsi.getParent() != null && !NESTED.contains(blockPsi.getParent().getNode().getElementType())) {
            subBlocks2 = new ArrayList();
            AlignmentProvider.Aligner dotsAligner = this.myContext.getSettings().ALIGN_MULTILINE_CHAINED_METHODS ? this.myAlignmentProvider.createAligner(false) : null;
            Wrap wrap = this.myWrappingProcessor.getChainedMethodCallWrap();
            this.addNestedChildren(this.myNode.getPsi(), subBlocks2, dotsAligner, true, wrap);
            return subBlocks2;
        }
        if (blockPsi instanceof GrListOrMap && ((GrListOrMap)blockPsi).isMap() && this.myContext.getGroovySettings().ALIGN_NAMED_ARGS_IN_MAP) {
            GrNamedArgument[] namedArgs;
            AlignmentProvider.Aligner labels = this.myAlignmentProvider.createAligner(false);
            AlignmentProvider.Aligner exprs = this.myAlignmentProvider.createAligner(true);
            for (GrNamedArgument arg : namedArgs = ((GrListOrMap)blockPsi).getNamedArguments()) {
                PsiElement colon;
                GrArgumentLabel label = arg.getLabel();
                if (label != null) {
                    labels.append(label);
                }
                if ((colon = arg.getColon()) == null) {
                    colon = arg.getExpression();
                }
                if (colon == null) continue;
                exprs.append(colon);
            }
        }
        if (GroovyBlockGenerator.isListLikeClause(blockPsi)) {
            subBlocks2 = new ArrayList<Block>();
            List<ASTNode> astNodes = GroovyBlockGenerator.visibleChildren(this.myNode);
            if (this.mustAlign(blockPsi, astNodes)) {
                AlignmentProvider.Aligner aligner = this.myAlignmentProvider.createAligner(false);
                for (ASTNode node : astNodes) {
                    if (GroovyBlockGenerator.isKeyword(node)) continue;
                    aligner.append(node.getPsi());
                }
            }
            for (ASTNode childNode : astNodes) {
                subBlocks2.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
            }
            return subBlocks2;
        }
        boolean classLevel = blockPsi instanceof GrTypeDefinitionBody;
        if (blockPsi instanceof GrClosableBlock && ((GrClosableBlock)blockPsi).getArrow() != null && ((GrClosableBlock)blockPsi).getParameters().length > 0 && !GroovyBlockGenerator.getClosureBodyVisibleChildren(this.myNode).isEmpty()) {
            GrClosableBlock closableBlock = (GrClosableBlock)blockPsi;
            ArrayList<Block> blocks = new ArrayList<Block>();
            PsiElement lbrace = closableBlock.getLBrace();
            if (lbrace != null) {
                ASTNode node = lbrace.getNode();
                blocks.add(new GroovyBlock(node, this.getIndent(node), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
            }
            Indent indent = Indent.getNormalIndent();
            ASTNode parameterListNode = closableBlock.getParameterList().getNode();
            ClosureBodyBlock bodyBlock = new ClosureBodyBlock(parameterListNode, indent, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext);
            blocks.add(bodyBlock);
            PsiElement rbrace = closableBlock.getRBrace();
            if (rbrace != null) {
                ASTNode node = rbrace.getNode();
                blocks.add(new GroovyBlock(node, this.getIndent(node), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
            }
            return blocks;
        }
        if (blockPsi instanceof GrCodeBlock || blockPsi instanceof GroovyFile || classLevel) {
            return this.generateSubBlockForCodeBlocks(classLevel, GroovyBlockGenerator.visibleChildren(this.myNode), this.myContext.getGroovySettings().INDENT_LABEL_BLOCKS);
        }
        if (blockPsi instanceof GrMethod) {
            subBlocks = new ArrayList<Block>();
            for (ASTNode childNode : GroovyBlockGenerator.getGroovyChildren(this.myNode)) {
                if (childNode.getElementType() == GroovyTokenTypes.mLPAREN || childNode.getElementType() == GroovyTokenTypes.mRPAREN) continue;
                if (childNode.getElementType() == GroovyElementTypes.PARAMETERS_LIST) {
                    subBlocks.add(new ParameterListBlock((GrMethod)blockPsi, Indent.getNoneIndent(), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
                    continue;
                }
                if (!GroovyBlockGenerator.canBeCorrectBlock(childNode)) continue;
                subBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
            }
            return subBlocks;
        }
        if (blockPsi instanceof GrTraditionalForClause) {
            if (this.myContext.getSettings().ALIGN_MULTILINE_FOR) {
                GrTraditionalForClause clause = (GrTraditionalForClause)blockPsi;
                AlignmentProvider.Aligner parenthesesAligner = this.myAlignmentProvider.createAligner(false);
                parenthesesAligner.append(clause.getInitialization());
                parenthesesAligner.append(clause.getCondition());
                parenthesesAligner.append(clause.getUpdate());
            }
        } else if (blockPsi instanceof GrBinaryExpression) {
            if (this.myContext.getSettings().ALIGN_MULTILINE_BINARY_OPERATION) {
                GrBinaryExpression binary = (GrBinaryExpression)blockPsi;
                GrExpression left = binary.getLeftOperand();
                GrExpression right = binary.getRightOperand();
                if (left != null && right != null) {
                    this.myAlignmentProvider.addPair(left, right, (Boolean)false);
                }
            }
        } else if (blockPsi instanceof GrAssignmentExpression) {
            if (this.myContext.getSettings().ALIGN_MULTILINE_ASSIGNMENT) {
                GrAssignmentExpression assignment = (GrAssignmentExpression)blockPsi;
                GrExpression lValue = assignment.getLValue();
                GrExpression rValue = assignment.getRValue();
                if (lValue != null && rValue != null) {
                    this.myAlignmentProvider.addPair(lValue, rValue, (Boolean)false);
                }
            }
        } else if (blockPsi instanceof GrConditionalExpression && this.myContext.getSettings().ALIGN_MULTILINE_TERNARY_OPERATION) {
            GrConditionalExpression conditional = (GrConditionalExpression)blockPsi;
            AlignmentProvider.Aligner exprAligner = this.myAlignmentProvider.createAligner(false);
            exprAligner.append(conditional.getCondition());
            if (!(conditional instanceof GrElvisExpression)) {
                exprAligner.append(conditional.getThenBranch());
            }
            exprAligner.append(conditional.getElseBranch());
            ASTNode question = conditional.getNode().findChildByType(GroovyTokenTypes.mQUESTION);
            ASTNode colon = conditional.getNode().findChildByType(GroovyTokenTypes.mCOLON);
            if (question != null && colon != null) {
                AlignmentProvider.Aligner questionColonAligner = this.myAlignmentProvider.createAligner(false);
                questionColonAligner.append(question.getPsi());
                questionColonAligner.append(colon.getPsi());
            }
        }
        subBlocks = new ArrayList();
        for (ASTNode childNode : GroovyBlockGenerator.visibleChildren(this.myNode)) {
            subBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
        }
        return subBlocks;
    }

    private Wrap getChildWrap(ASTNode childNode) {
        return this.myWrappingProcessor.getChildWrap(childNode);
    }

    public List<Block> generateSubBlockForCodeBlocks(boolean classLevel, List<ASTNode> children, boolean indentLabelBlocks) {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        if (indentLabelBlocks && this.isCodeBlock()) {
            List<ASTNode> flattenChildren = GroovyBlockGenerator.flattenChildren(children);
            this.calculateAlignments(flattenChildren, classLevel);
            for (int i = 0; i < flattenChildren.size(); ++i) {
                ASTNode childNode = flattenChildren.get(i);
                if (childNode.getElementType() == GroovyElementTypes.LABELED_STATEMENT) {
                    int start = i;
                    while (++i < flattenChildren.size() && flattenChildren.get(i).getElementType() != GroovyElementTypes.LABELED_STATEMENT && flattenChildren.get(i).getElementType() != GroovyTokenTypes.mRCURLY) {
                    }
                    subBlocks.add(new GrLabelBlock(childNode, flattenChildren.subList(start + 1, i), classLevel, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
                    --i;
                    continue;
                }
                subBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
            }
        } else {
            this.calculateAlignments(children, classLevel);
            for (ASTNode childNode : children) {
                subBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
            }
        }
        return subBlocks;
    }

    private boolean isCodeBlock() {
        IElementType type = this.myNode.getElementType();
        return type == GroovyElementTypes.OPEN_BLOCK || type == GroovyElementTypes.CLOSABLE_BLOCK || type == GroovyElementTypes.CONSTRUCTOR_BODY || type == GroovyParserDefinition.GROOVY_FILE;
    }

    private static List<ASTNode> flattenChildren(List<ASTNode> children) {
        ArrayList result = ContainerUtil.newArrayList();
        for (ASTNode child : children) {
            GroovyBlockGenerator.processNodeFlattening(result, child);
        }
        return result;
    }

    private static void processNodeFlattening(ArrayList<ASTNode> result, ASTNode child) {
        result.add(child);
        if (child.getElementType() == GroovyElementTypes.LABELED_STATEMENT) {
            for (ASTNode node : GroovyBlockGenerator.visibleChildren(child)) {
                GroovyBlockGenerator.processNodeFlattening(result, node);
            }
        }
    }

    private Indent getIndent(ASTNode childNode) {
        return new GroovyIndentProcessor().getChildIndent(this.myBlock, childNode);
    }

    private void calculateAlignments(List<ASTNode> children, boolean classLevel) {
        ArrayList currentGroup = null;
        boolean spock = true;
        for (ASTNode child : children) {
            PsiElement psi = child.getPsi();
            if (psi instanceof GrLabeledStatement) {
                this.alignGroup(currentGroup, spock, classLevel);
                currentGroup = ContainerUtil.newArrayList();
                spock = true;
                continue;
            }
            if (currentGroup != null && spock && GroovyBlockGenerator.isTablePart(psi)) {
                currentGroup.add((GrStatement)psi);
                continue;
            }
            if (psi instanceof GrVariableDeclaration) {
                GrVariable[] variables = ((GrVariableDeclaration)psi).getVariables();
                if (variables.length <= 0) continue;
                if (!classLevel || currentGroup == null || this.fieldGroupEnded(psi) || spock) {
                    this.alignGroup(currentGroup, spock, classLevel);
                    currentGroup = ContainerUtil.newArrayList();
                    spock = false;
                }
                currentGroup.add((GrStatement)psi);
                continue;
            }
            if (this.shouldSkip(classLevel, psi)) continue;
            this.alignGroup(currentGroup, spock, classLevel);
            currentGroup = null;
        }
        if (currentGroup != null) {
            this.alignGroup(currentGroup, spock, classLevel);
        }
    }

    private boolean shouldSkip(boolean classLevel, PsiElement psi) {
        PsiElement prev;
        if (psi instanceof PsiComment && ((prev = psi.getPrevSibling()) != null && prev.getNode().getElementType() != GroovyTokenTypes.mNLS || classLevel && !this.fieldGroupEnded(psi))) {
            return true;
        }
        return psi.getParent() instanceof GrLabeledStatement && !(psi instanceof GrStatement);
    }

    private void alignGroup(List<GrStatement> group, boolean spock, boolean classLevel) {
        if (group == null) {
            return;
        }
        if (spock) {
            this.alignSpockTable(group);
        } else {
            this.alignVariableDeclarations(group, classLevel);
        }
    }

    private void alignVariableDeclarations(List<GrStatement> group, boolean classLevel) {
        AlignmentProvider.Aligner typeElement = this.myAlignmentProvider.createAligner(true);
        AlignmentProvider.Aligner varName = this.myAlignmentProvider.createAligner(true);
        AlignmentProvider.Aligner eq = this.myAlignmentProvider.createAligner(true);
        for (GrStatement statement : group) {
            GrVariable[] variables;
            GrVariableDeclaration varDeclaration = (GrVariableDeclaration)statement;
            for (GrVariable variable : variables = varDeclaration.getVariables()) {
                varName.append(variable.getNameIdentifierGroovy());
            }
            if (!classLevel || !this.myContext.getSettings().ALIGN_GROUP_FIELD_DECLARATIONS) continue;
            typeElement.append(varDeclaration.getTypeElementGroovy());
            ASTNode current_eq = variables[variables.length - 1].getNode().findChildByType(GroovyTokenTypes.mASSIGN);
            if (current_eq == null) continue;
            eq.append(current_eq.getPsi());
        }
    }

    private void alignSpockTable(List<GrStatement> group) {
        int second;
        if (group.size() < 2) {
            return;
        }
        GrStatement inner = group.get(0);
        boolean embedded = inner != null && GroovyBlockGenerator.isTablePart(inner);
        GrStatement first = embedded ? inner : group.get(1);
        List alignments = ContainerUtil.map2List(GroovyBlockGenerator.getSpockTable(first), (Function)new Function<LeafPsiElement, AlignmentProvider.Aligner>(){

            public AlignmentProvider.Aligner fun(LeafPsiElement leaf) {
                return GroovyBlockGenerator.this.myAlignmentProvider.createAligner((PsiElement)leaf, true, Alignment.Anchor.RIGHT);
            }
        });
        for (int i = second = embedded ? 1 : 2; i < group.size(); ++i) {
            List<LeafPsiElement> table = GroovyBlockGenerator.getSpockTable(group.get(i));
            for (int j = 0; j < Math.min(table.size(), alignments.size()); ++j) {
                ((AlignmentProvider.Aligner)alignments.get(j)).append((PsiElement)table.get(j));
            }
        }
    }

    private boolean fieldGroupEnded(PsiElement psi) {
        if (!this.myContext.getSettings().ALIGN_GROUP_FIELD_DECLARATIONS) {
            return true;
        }
        PsiElement prevSibling = psi.getPrevSibling();
        return prevSibling != null && StringUtil.countChars((CharSequence)prevSibling.getText(), (char)'\n') >= this.myContext.getSettings().KEEP_BLANK_LINES_IN_DECLARATIONS;
    }

    private static List<LeafPsiElement> getSpockTable(GrStatement statement) {
        LinkedList<LeafPsiElement> result = new LinkedList<LeafPsiElement>();
        while (GroovyBlockGenerator.isTablePart(statement)) {
            result.addFirst((LeafPsiElement)((GrBinaryExpression)statement).getOperationToken());
            statement = ((GrBinaryExpression)statement).getLeftOperand();
        }
        return result;
    }

    private static boolean isTablePart(PsiElement psi) {
        return psi instanceof GrBinaryExpression && (GroovyTokenTypes.mBOR == ((GrBinaryExpression)psi).getOperationTokenType() || GroovyTokenTypes.mLOR == ((GrBinaryExpression)psi).getOperationTokenType());
    }

    public static List<ASTNode> visibleChildren(ASTNode node) {
        ArrayList<ASTNode> list = new ArrayList<ASTNode>();
        for (ASTNode astNode : GroovyBlockGenerator.getGroovyChildren(node)) {
            if (!GroovyBlockGenerator.canBeCorrectBlock(astNode)) continue;
            list.add(astNode);
        }
        return list;
    }

    private boolean mustAlign(PsiElement blockPsi, List<ASTNode> children) {
        if (blockPsi instanceof GrArgumentList && this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS) {
            return children.size() != 3 || children.get(0).getElementType() != GroovyTokenTypes.mLPAREN || children.get(1).getElementType() != GroovyElementTypes.CLOSABLE_BLOCK && children.get(1).getElementType() != GroovyElementTypes.LIST_OR_MAP || children.get(2).getElementType() != GroovyTokenTypes.mRPAREN;
        }
        if (blockPsi instanceof GrAssignmentExpression && ((GrAssignmentExpression)blockPsi).getRValue() instanceof GrAssignmentExpression) {
            return this.myContext.getSettings().ALIGN_MULTILINE_ASSIGNMENT;
        }
        return blockPsi instanceof GrParameterList && this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS || blockPsi instanceof GrExtendsClause && this.myContext.getSettings().ALIGN_MULTILINE_EXTENDS_LIST || blockPsi instanceof GrThrowsClause && this.myContext.getSettings().ALIGN_MULTILINE_THROWS_LIST || blockPsi instanceof GrListOrMap && this.myContext.getGroovySettings().ALIGN_MULTILINE_LIST_OR_MAP;
    }

    private static boolean isListLikeClause(PsiElement blockPsi) {
        return blockPsi instanceof GrParameterList || blockPsi instanceof GrArgumentList || blockPsi instanceof GrAssignmentExpression || blockPsi instanceof GrExtendsClause || blockPsi instanceof GrThrowsClause || blockPsi instanceof GrListOrMap;
    }

    private static boolean isKeyword(ASTNode node) {
        if (node == null) {
            return false;
        }
        return TokenSets.KEYWORDS.contains(node.getElementType()) || TokenSets.BRACES.contains(node.getElementType()) && !((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(")")).withParent(GrArgumentList.class)).afterLeaf(new String[]{","})).accepts((Object)node.getPsi());
    }

    private List<Block> generateForMultiLineString() {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        int start = this.myNode.getTextRange().getStartOffset();
        int end = this.myNode.getTextRange().getEndOffset();
        subBlocks.add(new GroovyBlockWithRange(this.myNode, Indent.getNoneIndent(), new TextRange(start, start + 3), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        subBlocks.add(new GroovyBlockWithRange(this.myNode, Indent.getAbsoluteNoneIndent(), new TextRange(start + 3, end - 3), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        subBlocks.add(new GroovyBlockWithRange(this.myNode, Indent.getAbsoluteNoneIndent(), new TextRange(end - 3, end), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        return subBlocks;
    }

    private static boolean canBeCorrectBlock(ASTNode node) {
        return !node.getText().trim().isEmpty();
    }

    private static ASTNode[] getGroovyChildren(ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi instanceof OuterLanguageElement) {
            TextRange range = node.getTextRange();
            ArrayList<ASTNode> childList = new ArrayList<ASTNode>();
            PsiFile groovyFile = psi.getContainingFile().getViewProvider().getPsi((Language)GroovyLanguage.INSTANCE);
            if (groovyFile instanceof GroovyFileBase) {
                GroovyBlockGenerator.addChildNodes((PsiElement)groovyFile, childList, range);
            }
            return childList.toArray(new ASTNode[childList.size()]);
        }
        return node.getChildren(null);
    }

    private static void addChildNodes(PsiElement elem, ArrayList<ASTNode> childNodes, TextRange range) {
        ASTNode node = elem.getNode();
        if (range.contains(elem.getTextRange()) && node != null) {
            childNodes.add(node);
        } else {
            for (PsiElement child : elem.getChildren()) {
                GroovyBlockGenerator.addChildNodes(child, childNodes, range);
            }
        }
    }

    private List<Block> generateForBinaryExpr() {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        AlignmentProvider.Aligner alignment = this.myContext.getSettings().ALIGN_MULTILINE_BINARY_OPERATION ? this.myAlignmentProvider.createAligner(false) : null;
        GrBinaryExpression binary = (GrBinaryExpression)this.myNode.getPsi();
        LOG.assertTrue(binary != null);
        this.addBinaryChildrenRecursively(binary, subBlocks, Indent.getContinuationWithoutFirstIndent(), alignment);
        return subBlocks;
    }

    private void addBinaryChildrenRecursively(PsiElement elem, List<Block> list, Indent indent, AlignmentProvider.Aligner aligner) {
        if (elem == null) {
            return;
        }
        if (elem instanceof GrBinaryExpression) {
            GrBinaryExpression myExpr = (GrBinaryExpression)elem;
            if (myExpr.getLeftOperand() instanceof GrBinaryExpression) {
                this.addBinaryChildrenRecursively(myExpr.getLeftOperand(), list, Indent.getContinuationWithoutFirstIndent(), aligner);
            }
            PsiElement op = ((GrBinaryExpression)elem).getOperationToken();
            for (ASTNode childNode : GroovyBlockGenerator.visibleChildren(elem.getNode())) {
                PsiElement psi = childNode.getPsi();
                if (psi instanceof GrBinaryExpression) continue;
                if (op != psi && aligner != null) {
                    aligner.append(psi);
                }
                list.add(new GroovyBlock(childNode, indent, this.getChildWrap(childNode), this.myContext));
            }
            if (myExpr.getRightOperand() instanceof GrBinaryExpression) {
                this.addBinaryChildrenRecursively(myExpr.getRightOperand(), list, Indent.getContinuationWithoutFirstIndent(), aligner);
            }
        }
    }

    private void addNestedChildren(PsiElement elem, List<Block> list, AlignmentProvider.Aligner aligner, boolean topLevel, Wrap wrap) {
        PsiElement nameElement;
        GrExpression invokedExpression;
        List<ASTNode> children = GroovyBlockGenerator.visibleChildren(elem.getNode());
        if (elem instanceof GrMethodCallExpression && (invokedExpression = ((GrMethodCallExpression)elem).getInvokedExpression()) instanceof GrQualifiedReference && (nameElement = ((GrQualifiedReference)((Object)invokedExpression)).getReferenceNameElement()) != null) {
            int i;
            List<ASTNode> grandChildren = GroovyBlockGenerator.visibleChildren(invokedExpression.getNode());
            for (i = 0; i < grandChildren.size() && nameElement != grandChildren.get(i).getPsi(); ++i) {
            }
            if (i > 0) {
                this.processNestedChildrenPrefix(list, aligner, false, grandChildren, i, wrap);
            }
            if (i < grandChildren.size()) {
                LOG.assertTrue(nameElement == grandChildren.get(i).getPsi());
                list.add(new MethodCallWithoutQualifierBlock(nameElement, wrap, topLevel, children, elem, this.myContext));
            }
            return;
        }
        this.processNestedChildrenPrefix(list, aligner, topLevel, children, children.size(), wrap);
    }

    private static boolean isAfterMultiLineClosure(ASTNode dot) {
        PsiElement last;
        PsiElement dotPsi = dot.getPsi();
        PsiElement prev = PsiUtil.skipWhitespaces(dotPsi.getPrevSibling(), false);
        if (prev != null && prev instanceof GrMethodCall && (last = prev.getLastChild()) instanceof GrClosableBlock) {
            return last.getText().contains("\n");
        }
        return false;
    }

    private void processNestedChildrenPrefix(List<Block> list, AlignmentProvider.Aligner aligner, boolean topLevel, List<ASTNode> children, int limit, Wrap wrap) {
        ASTNode fst = children.get(0);
        LOG.assertTrue(limit > 0);
        if (NESTED.contains(fst.getElementType())) {
            this.addNestedChildren(fst.getPsi(), list, aligner, false, wrap);
        } else {
            Indent indent = Indent.getContinuationWithoutFirstIndent();
            list.add(new GroovyBlock(fst, indent, this.getChildWrap(fst), this.myContext));
        }
        this.addNestedChildrenSuffix(list, aligner, topLevel, children, limit);
    }

    void addNestedChildrenSuffix(List<Block> list, AlignmentProvider.Aligner aligner, boolean topLevel, List<ASTNode> children, int limit) {
        for (int i = 1; i < limit; ++i) {
            Indent indent;
            ASTNode childNode = children.get(i);
            if (!GroovyBlockGenerator.canBeCorrectBlock(childNode)) continue;
            IElementType type = childNode.getElementType();
            Indent indent2 = indent = topLevel || NESTED.contains(type) || type == GroovyTokenTypes.mIDENT || TokenSets.DOTS.contains(type) && !GroovyBlockGenerator.isAfterMultiLineClosure(childNode) ? Indent.getContinuationWithoutFirstIndent() : Indent.getNoneIndent();
            if (aligner != null && TokenSets.DOTS.contains(type)) {
                aligner.append(childNode.getPsi());
            }
            list.add(new GroovyBlock(childNode, indent, this.getChildWrap(childNode), this.myContext));
        }
    }
}

