/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;
import org.jetbrains.plugins.groovy.gant.GantUtils;

public class GantLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    private static final LibraryKind GANT_KIND = LibraryKind.create((String)"gant");

    public GantLibraryPresentationProvider() {
        super(GANT_KIND);
    }

    @Override
    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return GantUtils.isGantLibrary(libraryFiles);
    }

    @Override
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        return GantUtils.getGantVersion(GantUtils.getGantLibraryHome(libraryFiles));
    }

    @Override
    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Gant_sdk;
    }

    @Override
    public boolean isSDKHome(VirtualFile file) {
        return GantUtils.isGantSdkHome(file);
    }

    @Override
    public String getSDKVersion(String path) {
        return GantUtils.getGantVersion(path);
    }

    @Override
    public String getLibraryCategoryName() {
        return "Gant";
    }

    @Override
    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File lib;
        File[] jars;
        File srcRoot = new File(path + "/src/main");
        if (srcRoot.exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcRoot), OrderRootType.SOURCES);
        }
        File[] fileArray = jars = (lib = new File(path + "/lib")).exists() ? lib.listFiles() : new File[]{};
        if (jars != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }
}

